/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler;

import guideme.PageAnchor;
import guideme.compiler.IdUtils;
import guideme.compiler.PageCompiler;
import java.net.URI;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public final class LinkParser {
    private LinkParser() {
    }

    public static void parseLink(PageCompiler compiler, String href, Visitor visitor) {
        ResourceLocation pageId;
        URI uri;
        try {
            uri = URI.create(href);
        }
        catch (Exception ignored) {
            uri = null;
        }
        if (uri != null && uri.isAbsolute() && (uri.getScheme().equals("http") || uri.getScheme().equalsIgnoreCase("https"))) {
            visitor.handleExternal(uri);
            return;
        }
        String fragment = null;
        int fragmentSep = href.indexOf(35);
        if (fragmentSep != -1) {
            fragment = href.substring(fragmentSep + 1);
            href = href.substring(0, fragmentSep);
        }
        try {
            pageId = IdUtils.resolveLink(href, compiler.getPageId());
        }
        catch (ResourceLocationException ignored) {
            visitor.handleError("Invalid link");
            return;
        }
        if (!compiler.getPageCollection().pageExists(pageId)) {
            visitor.handleError("Page does not exist");
            return;
        }
        visitor.handlePage(new PageAnchor(pageId, fragment));
    }

    public static interface Visitor {
        default public void handlePage(PageAnchor page) {
        }

        default public void handleExternal(URI uri) {
        }

        default public void handleError(String error) {
        }
    }
}

