/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.plugin;

import com.hrznstudio.titanium.annotation.plugin.FeaturePlugin;
import com.hrznstudio.titanium.plugin.FeaturePluginInstance;
import com.hrznstudio.titanium.plugin.PluginPhase;
import com.hrznstudio.titanium.util.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginManager {
    private final Logger LOGGER = LogManager.getLogger((String)"PluginManager");
    private final String modid;
    private final FeaturePlugin.FeaturePluginType type;
    private final Predicate<FeaturePlugin> predicate;
    private final List<Class> plugins;
    private List<FeaturePluginInstance> instances;
    private final boolean useModIdFilter;

    public PluginManager(String modid, FeaturePlugin.FeaturePluginType type, String featureNameCheck, boolean useModIdFilter) {
        this(modid, type, (FeaturePlugin featurePlugin) -> featurePlugin.value().equalsIgnoreCase(featureNameCheck), useModIdFilter);
    }

    public PluginManager(String modid, FeaturePlugin.FeaturePluginType type, Predicate<FeaturePlugin> predicate, boolean useModIdFilter) {
        this.modid = modid;
        this.type = type;
        this.predicate = predicate;
        this.useModIdFilter = useModIdFilter;
        this.plugins = this.collect();
        this.plugins.forEach(aClass -> this.LOGGER.info("Found FeaturePluginInstance for class " + aClass.getSimpleName() + " for plugin " + aClass.getAnnotation(FeaturePlugin.class).value()));
    }

    private List<Class> collect() {
        this.LOGGER.info("Scanning classes for " + this.modid);
        return (this.useModIdFilter ? AnnotationUtil.getFilteredAnnotatedClasses(FeaturePlugin.class, this.modid) : AnnotationUtil.getAnnotatedClasses(FeaturePlugin.class)).stream().filter(aClass -> FeaturePluginInstance.class.isAssignableFrom((Class<?>)aClass) && aClass.getAnnotation(FeaturePlugin.class).type().equals((Object)this.type) && this.predicate.test(aClass.getAnnotation(FeaturePlugin.class))).collect(Collectors.toList());
    }

    public List<FeaturePluginInstance> getPluginsConstructed() {
        if (this.instances == null) {
            this.instances = new ArrayList<FeaturePluginInstance>();
            this.plugins.forEach(aClass -> {
                try {
                    this.instances.add((FeaturePluginInstance)aClass.newInstance());
                    this.LOGGER.info("Constructed class " + aClass.getSimpleName() + " for plugin " + aClass.getAnnotation(FeaturePlugin.class).value() + " for mod " + this.modid);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.LOGGER.error((Object)e);
                }
            });
        }
        return this.instances;
    }

    public void execute(PluginPhase phase) {
        this.getPluginsConstructed().forEach(featurePluginInstance -> {
            this.LOGGER.info("Executing phase " + phase.toString() + " for plugin class " + featurePluginInstance.getClass().getSimpleName());
            featurePluginInstance.execute(phase);
        });
    }
}

