/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.hrznstudio.titanium.json.IJsonProvider;
import com.hrznstudio.titanium.json.jsondirector.IJsonDirector;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.Tuple;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class JsonLoader<T>
extends SimpleJsonResourceReloadListener {
    private final IJsonDirector<T> director;
    private final String type;
    private final Logger logger;
    private final IJsonProvider<T> jsonProvider;

    public JsonLoader(String type, Logger logger, IJsonDirector<T> director, IJsonProvider<T> jsonProvider) {
        super(new Gson(), type);
        this.type = type;
        this.logger = logger;
        this.director = director;
        this.jsonProvider = jsonProvider;
    }

    private ResourceLocation transformRL(ResourceLocation resource) {
        return ResourceLocation.fromNamespaceAndPath((String)resource.getNamespace(), (String)resource.getPath().replace(this.type + "/", ""));
    }

    protected void apply(Map<ResourceLocation, JsonElement> ts, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.director.clear();
        ts.entrySet().parallelStream().map(entry -> new Tuple((Object)((ResourceLocation)entry.getKey()), this.jsonProvider.provide((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()))).forEach(tuple -> this.director.put((ResourceLocation)tuple.getA(), tuple.getB()));
        this.logger.info("Loaded " + ts.size() + " " + this.type);
    }
}

