/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container;

import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BasicContainer
extends AbstractContainerMenu {
    private final IAssetProvider assetProvider;

    public BasicContainer(int id, Inventory inventory, FriendlyByteBuf buffer) {
        this(inventory.player.containerMenu.getType(), id);
    }

    public BasicContainer(MenuType type, int id) {
        super(type, id);
        this.assetProvider = IAssetProvider.DEFAULT_PROVIDER;
    }

    public BasicContainer(MenuType type, int id, IAssetProvider assetProvider) {
        super(type, id);
        this.assetProvider = assetProvider;
    }

    public boolean stillValid(Player playerIn) {
        return false;
    }

    public ItemStack quickMoveStack(Player player, int slotPos) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotPos);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int containerSlots = this.slots.size() - 36;
            if (slotPos < containerSlots ? !this.moveItemStackTo(itemstack1, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public IAssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void addExtraSlots() {
    }
}

