/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.fluid;

import com.buuz135.functionalstorage.util.Utils;
import com.mojang.serialization.DynamicOps;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public abstract class BigFluidHandler
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    private CustomFluidTank[] tanks;
    private FluidStack[] filterStack;
    private int capacity;

    public BigFluidHandler(int size, int capacity) {
        this.tanks = new CustomFluidTank[size];
        this.filterStack = new FluidStack[size];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.filterStack[i] = FluidStack.EMPTY;
            int finalI = i;
            this.tanks[i] = new CustomFluidTank(capacity, fluidStack -> {
                if (this.isDrawerLocked()) {
                    return FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)this.filterStack[finalI]);
                }
                return true;
            });
        }
        this.capacity = capacity;
    }

    public CustomFluidTank[] getTankList() {
        return this.tanks;
    }

    public int getTanks() {
        return this.tanks.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.tanks[tank].getFluidInTank(0);
    }

    public int getTankCapacity(int tank) {
        return this.tanks[tank].getTankCapacity(0);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.tanks[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (CustomFluidTank tank : this.tanks) {
            if (tank.getFluid().isEmpty() || tank.fill(resource, IFluidHandler.FluidAction.SIMULATE) == 0) continue;
            int ret = tank.fill(resource, action);
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.onChange();
            }
            return ret;
        }
        for (CustomFluidTank tank : this.tanks) {
            if (!tank.getFluid().isEmpty() || tank.fill(resource, IFluidHandler.FluidAction.SIMULATE) == 0) continue;
            int ret = tank.fill(resource, action);
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.onChange();
            }
            return ret;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (CustomFluidTank tank : this.tanks) {
            if (tank.getFluid().isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)resource) || tank.drain(resource, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
            FluidStack ret = tank.drain(resource, action);
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.onChange();
            }
            return ret;
        }
        for (CustomFluidTank tank : this.tanks) {
            if (tank.drain(resource, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
            FluidStack ret = tank.drain(resource, action);
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.onChange();
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (CustomFluidTank tank : this.tanks) {
            if (tank.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
            FluidStack ret = tank.drain(maxDrain, action);
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.onChange();
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        for (CustomFluidTank tank : this.tanks) {
            tank.setCapacity(capacity);
            if (tank.getFluid().isEmpty()) continue;
            tank.getFluid().setAmount(Math.min(tank.getFluidAmount(), capacity));
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.tanks.length; ++i) {
            compoundTag.put("" + i, (Tag)this.tanks[i].writeToNBT(provider, new CompoundTag()));
            compoundTag.put("Locked" + i, (Tag)FluidStack.OPTIONAL_CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider), (Object)this.filterStack[i]).getOrThrow());
        }
        compoundTag.putInt("Capacity", this.capacity);
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.capacity = nbt.getInt("Capacity");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(provider, nbt.getCompound("" + i));
            this.tanks[i].setCapacity(this.capacity);
            this.filterStack[i] = Utils.deserializeFluid(provider, nbt.getCompound("Locked" + i));
        }
    }

    public abstract void onChange();

    public abstract boolean isDrawerLocked();

    public abstract boolean isDrawerVoid();

    public abstract boolean isDrawerCreative();

    public void lockHandler() {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.filterStack[i] = this.tanks[i].getFluid().copy();
            if (this.filterStack[i].isEmpty()) continue;
            this.filterStack[i].setAmount(1);
        }
    }

    public FluidStack[] getFilterStack() {
        return this.filterStack;
    }

    public class CustomFluidTank
    extends FluidTank {
        public CustomFluidTank(int capacity) {
            super(capacity);
        }

        public CustomFluidTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int amount = super.fill(resource, action);
            if (BigFluidHandler.this.isDrawerVoid() && (BigFluidHandler.this.isDrawerLocked() && this.isFluidValid(resource) || !this.getFluid().isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)this.getFluid(), (FluidStack)resource))) {
                return resource.getAmount();
            }
            return amount;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            FluidStack stack = super.getFluidInTank(tank);
            if (!stack.isEmpty() && BigFluidHandler.this.isDrawerCreative()) {
                stack.setAmount(Integer.MAX_VALUE);
            }
            return stack;
        }

        public int getTankCapacity(int tank) {
            return BigFluidHandler.this.isDrawerCreative() ? Integer.MAX_VALUE : super.getTankCapacity(tank);
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BigFluidHandler.this.isDrawerCreative()) {
                return resource.copy();
            }
            return super.drain(resource, action);
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack fluidStack = super.drain(maxDrain, action);
            if (BigFluidHandler.this.isDrawerCreative()) {
                fluidStack.setAmount(maxDrain);
            }
            return fluidStack;
        }

        public int getCapacity() {
            return BigFluidHandler.this.isDrawerCreative() ? Integer.MAX_VALUE : super.getCapacity();
        }

        @NotNull
        public FluidStack getFluid() {
            FluidStack stack = super.getFluid();
            if (!stack.isEmpty() && BigFluidHandler.this.isDrawerCreative()) {
                stack.setAmount(Integer.MAX_VALUE);
            }
            return stack;
        }

        public int getFluidAmount() {
            return BigFluidHandler.this.isDrawerCreative() ? Integer.MAX_VALUE : super.getFluidAmount();
        }
    }
}

