/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.external.nonapi.io.github.classgraph.classloaderhandler;

import craftpresence.external.io.github.classgraph.ClassGraphClassLoader;
import craftpresence.external.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import craftpresence.external.nonapi.io.github.classgraph.classpath.ClassLoaderFinder;
import craftpresence.external.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import craftpresence.external.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import craftpresence.external.nonapi.io.github.classgraph.scanspec.ScanSpec;
import craftpresence.external.nonapi.io.github.classgraph.utils.LogNode;
import java.net.URL;

class ClassGraphClassLoaderHandler
implements ClassLoaderHandler {
    private ClassGraphClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        boolean matches = ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, "craftpresence.external.io.github.classgraph.ClassGraphClassLoader");
        if (matches && log != null) {
            log.log("Sharing a `ClassGraphClassLoader` between multiple nested scans is not advisable, because scan criteria may differ between scans. See: https://github.com/classgraph/classgraph/issues/485");
        }
        return matches;
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        for (URL url : ((ClassGraphClassLoader)classLoader).getURLs()) {
            if (url == null) continue;
            classpathOrder.addClasspathEntry((Object)url, classLoader, scanSpec, log);
        }
    }
}

