/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.neoforge.config;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.neoforge.config.NeoForgeIcebergConfigSpec;
import com.anthonyhilyard.iceberg.util.UnsafeUtil;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ConfigValueWrapper<T, S extends ModConfigSpec.ConfigValue<T>>
implements Supplier<T> {
    private final S configValue;
    private static Map<Class<?>, Field> pathFields = Maps.newHashMap();
    private static Map<Class<?>, Field> defaultSupplierFields = Maps.newHashMap();
    private static Map<Class<?>, Field> cachedValueFields = Maps.newHashMap();
    private static Map<Class<?>, Field> specFields = Maps.newHashMap();

    public ConfigValueWrapper(S configValue) {
        this.configValue = configValue;
    }

    private static Field findField(Class<?> startClass, String fieldName) {
        for (Class<?> currentClass = startClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private <U extends Enum<U>> U getRawEnum(Config config, List<String> path, Class<U> clazz, Supplier<U> defaultSupplier) {
        return (U)config.getEnumOrElse(path, clazz, EnumGetMethod.NAME_IGNORECASE, defaultSupplier);
    }

    @Override
    public T get() {
        Class<?> configValueClass = this.configValue.getClass();
        if (!pathFields.containsKey(configValueClass)) {
            try {
                pathFields.put(configValueClass, ConfigValueWrapper.findField(configValueClass, "path"));
                defaultSupplierFields.put(configValueClass, ConfigValueWrapper.findField(configValueClass, "defaultSupplier"));
                cachedValueFields.put(configValueClass, ConfigValueWrapper.findField(configValueClass, "cachedValue"));
                specFields.put(configValueClass, ConfigValueWrapper.findField(configValueClass, "spec"));
            }
            catch (Exception e) {
                Iceberg.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (pathFields.containsKey(configValueClass)) {
            try {
                Object cachedValue = cachedValueFields.get(configValueClass).get(this.configValue);
                if (cachedValue == null) {
                    NeoForgeIcebergConfigSpec spec = (NeoForgeIcebergConfigSpec)UnsafeUtil.getField(specFields.get(configValueClass), this.configValue);
                    Preconditions.checkState((spec != null ? 1 : 0) != 0, (Object)"Cannot get config value before spec is built.");
                    Preconditions.checkState((spec.loadedConfig() != null ? 1 : 0) != 0, (Object)"Cannot get config value before config is loaded.");
                    List path = (List)UnsafeUtil.getField(pathFields.get(configValueClass), this.configValue);
                    Supplier defaultSupplier = (Supplier)UnsafeUtil.getField(defaultSupplierFields.get(configValueClass), this.configValue);
                    Object value = spec.loadedConfig().config().getOrElse(path, defaultSupplier);
                    if (configValueClass == ModConfigSpec.EnumValue.class) {
                        Field clazzField = ModConfigSpec.EnumValue.class.getDeclaredField("clazz");
                        clazzField.setAccessible(true);
                        value = this.getRawEnum((Config)spec.loadedConfig().config(), path, (Class)UnsafeUtil.getField(clazzField, this.configValue), defaultSupplier);
                    }
                    if (value instanceof Number) {
                        Number number = (Number)value;
                        if (configValueClass == ModConfigSpec.IntValue.class) {
                            value = number.intValue();
                        } else if (configValueClass == ModConfigSpec.LongValue.class) {
                            value = number.longValue();
                        } else if (configValueClass == ModConfigSpec.DoubleValue.class) {
                            value = number.doubleValue();
                        }
                    }
                    cachedValue = value;
                    UnsafeUtil.setField(cachedValueFields.get(configValueClass), this.configValue, cachedValue);
                }
                return (T)cachedValue;
            }
            catch (Exception e) {
                Iceberg.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        Preconditions.checkState((boolean)false);
        return null;
    }
}

