/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.sequencedpulsegenerator;

import com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorBlock;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.EndInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.Instruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.InstructionResult;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopForInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopIfInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.OutputInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.WaitForInstruction;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Vector;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SequencedPulseGeneratorBlockEntity
extends SmartBlockEntity {
    public static final int INSTRUCTION_CAPACITY = 7;
    private static final int MAX_RECURSION_DEPTH = 10;
    private static final float PARTICLE_DENSITY = 0.2f;
    Vector<Instruction> instructions = Instruction.createDefault();
    int currentInstruction = -1;
    int currentSignal = 0;
    boolean poweredPreviously = false;
    boolean isPowered;
    int infiniteLoopCounter = 0;

    public SequencedPulseGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        AdvancementBehaviour.registerAwardables(this, behaviours, CCAdvancements.PULSE_GEN_INFINITE_LOOP);
    }

    public boolean isIdle() {
        return this.currentInstruction < 0;
    }

    public int getCurrentSignal() {
        return this.currentSignal;
    }

    public boolean isPoweredPreviously() {
        return this.poweredPreviously;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public Instruction getCurrentInstruction() {
        return this.currentInstruction >= 0 && this.currentInstruction < this.instructions.size() ? this.instructions.get(this.currentInstruction) : null;
    }

    private void executeInstruction(Function<Instruction, Function<SequencedPulseGeneratorBlockEntity, InstructionResult>> instructionEvent, boolean allowImmediate) {
        this.executeInstruction(instructionEvent, allowImmediate, 0);
    }

    private void applySignal() {
        if ((Boolean)this.getBlockState().getValue((Property)SequencedPulseGeneratorBlock.POWERING) != this.currentSignal > 0) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SequencedPulseGeneratorBlock.POWERING, (Comparable)Boolean.valueOf(this.currentSignal > 0)), 2);
        }
        ((SequencedPulseGeneratorBlock)this.getBlockState().getBlock()).updateNeighborsInFront(this.level, this.getBlockPos(), this.getBlockState());
    }

    private void executeInstruction(Function<Instruction, Function<SequencedPulseGeneratorBlockEntity, InstructionResult>> instructionEvent, boolean allowImmediate, int recursionDepth) {
        Instruction instruction = this.getCurrentInstruction();
        if (instruction == null) {
            this.currentInstruction = -1;
            if (this.currentSignal != 0) {
                this.currentSignal = 0;
                this.applySignal();
            }
            return;
        }
        InstructionResult result = instructionEvent.apply(instruction).apply(this);
        int prevSignal = this.currentSignal;
        this.currentSignal = instruction.getSignal();
        if (prevSignal != this.currentSignal) {
            this.applySignal();
        }
        this.currentInstruction = result.getNextInstruction(this.currentInstruction);
        if (result.isImmediate() && allowImmediate) {
            if (recursionDepth < 10) {
                this.executeInstruction(instructionEvent, true, recursionDepth + 1);
            } else {
                ++this.infiniteLoopCounter;
                if (this.level.getRandom().nextFloat() < 0.2f) {
                    Vec3 loc = Vec3.atBottomCenterOf((Vec3i)this.getBlockPos());
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, loc.x, loc.y, loc.z, 2, 0.1, 0.0, 0.1, 0.01);
                }
                if (!this.level.isClientSide() && this.infiniteLoopCounter > 101) {
                    this.infiniteLoopCounter = 0;
                    AdvancementBehaviour.tryAward((BlockEntity)this, CCAdvancements.PULSE_GEN_INFINITE_LOOP);
                }
            }
        } else {
            this.infiniteLoopCounter = 0;
        }
        if (recursionDepth == 0) {
            this.notifyUpdate();
        }
    }

    public void tick() {
        super.tick();
        if (this.isIdle()) {
            return;
        }
        if (this.level.isClientSide) {
            return;
        }
        this.isPowered = (Boolean)this.getBlockState().getValue((Property)DiodeBlock.POWERED);
        this.executeInstruction(i -> i::tick, true);
    }

    private void resetAllInstructions() {
        Vector newInstructions = new Vector(this.instructions.capacity());
        this.instructions.forEach(i -> newInstructions.add(i.copy()));
        this.instructions = newInstructions;
    }

    public void onRedstoneUpdate(boolean isPowered) {
        this.isPowered = isPowered;
        if (isPowered == this.poweredPreviously) {
            return;
        }
        if (!this.poweredPreviously && isPowered && !this.isIdle()) {
            this.executeInstruction(i -> i::onRisingEdge, false);
        }
        if (this.poweredPreviously && !isPowered && !this.isIdle()) {
            this.executeInstruction(i -> i::onFallingEdge, false);
        }
        this.poweredPreviously = isPowered;
        if (!this.isIdle() || !isPowered) {
            return;
        }
        if (!this.level.hasNeighborSignal(this.worldPosition)) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DiodeBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        this.currentInstruction = 0;
        this.resetAllInstructions();
        this.executeInstruction(i -> i::tick, true);
    }

    public void reset() {
        this.resetAllInstructions();
        this.currentInstruction = -1;
        this.infiniteLoopCounter = 0;
        this.currentSignal = 0;
        this.applySignal();
        this.notifyUpdate();
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.putInt("InstructionIndex", this.currentInstruction);
        tag.putBoolean("PrevPowered", this.poweredPreviously);
        tag.putInt("CurrentSignal", this.currentSignal);
        tag.put("Instructions", (Tag)Instruction.serializeAll(this.instructions));
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.currentInstruction = tag.getInt("InstructionIndex");
        this.poweredPreviously = tag.getBoolean("PrevPowered");
        this.currentSignal = tag.getInt("CurrentSignal");
        ListTag list = tag.getList("Instructions", 10);
        this.instructions = Instruction.deserializeAll(list);
        super.read(tag, registries, clientPacket);
    }

    static {
        Instruction.register(new OutputInstruction(10, 15));
        Instruction.register(new WaitForInstruction(1, 0));
        Instruction.register(new LoopForInstruction(3));
        Instruction.register(new LoopIfInstruction(1));
        Instruction.register(new LoopInstruction());
        Instruction.register(new EndInstruction());
    }
}

