/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.itemsilo;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.content.itemsilo.ItemSiloBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemSiloBlock
extends Block
implements IWrenchable,
IBE<ItemSiloBlockEntity> {
    public static final BooleanProperty LARGE = ItemVaultBlock.LARGE;
    public static final SoundType SILENCED_METAL = new DeferredSoundType(0.1f, 1.5f, () -> SoundEvents.NETHERITE_BLOCK_BREAK, () -> SoundEvents.NETHERITE_BLOCK_STEP, () -> SoundEvents.NETHERITE_BLOCK_PLACE, () -> SoundEvents.NETHERITE_BLOCK_HIT, () -> SoundEvents.NETHERITE_BLOCK_FALL);

    public ItemSiloBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LARGE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LARGE});
        super.createBlockStateDefinition(pBuilder);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.getBlock() == pState.getBlock()) {
            return;
        }
        if (pIsMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, ItemSiloBlockEntity::updateConnectivity);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean pIsMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof ItemSiloBlockEntity)) {
                return;
            }
            ItemSiloBlockEntity vaultBE = (ItemSiloBlockEntity)be;
            ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)vaultBE.inventory);
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)vaultBE);
        }
    }

    public static boolean isVault(BlockState state) {
        return CCBlocks.ITEM_SILO.has(state);
    }

    @Nullable
    public static Direction.Axis getVaultBlockAxis(BlockState state) {
        if (!ItemSiloBlock.isVault(state)) {
            return null;
        }
        return Direction.Axis.Y;
    }

    public static boolean isLarge(BlockState state) {
        if (!ItemSiloBlock.isVault(state)) {
            return false;
        }
        return (Boolean)state.getValue((Property)LARGE);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().contains("SilenceVaultSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return ItemHelper.calcRedstoneFromBlockEntity((IBE)this, (Level)pLevel, (BlockPos)pPos);
    }

    public BlockEntityType<? extends ItemSiloBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.ITEM_SILO.get();
    }

    public Class<ItemSiloBlockEntity> getBlockEntityClass() {
        return ItemSiloBlockEntity.class;
    }
}

