/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import plus.dragons.createdragonsplus.mixin.minecraft.RecipeManagerAccessor;

public class UpdateRecipesEvent
extends Event {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RecipeManager recipeManager;
    private final Multimap<RecipeType<?>, RecipeHolder<?>> byType;
    private final Map<ResourceLocation, RecipeHolder<?>> byName;
    private int added;
    private int removed;

    @ApiStatus.Internal
    public UpdateRecipesEvent(RecipeManager recipeManager, Multimap<RecipeType<?>, RecipeHolder<?>> byType, Map<ResourceLocation, RecipeHolder<?>> byName) {
        this.recipeManager = recipeManager;
        this.byType = byType;
        this.byName = byName;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public void addRecipe(RecipeHolder<?> recipe) {
        this.byType.put((Object)recipe.value().getType(), recipe);
        this.byName.put(recipe.id(), recipe);
        ++this.added;
    }

    public void removeRecipe(RecipeHolder<?> recipe) {
        this.byType.remove((Object)recipe.value().getType(), recipe);
        this.byName.remove(recipe.id());
        ++this.removed;
    }

    @ApiStatus.Internal
    public void apply() {
        ((RecipeManagerAccessor)this.recipeManager).setByType((Multimap<RecipeType<?>, RecipeHolder<?>>)ImmutableMultimap.copyOf(this.byType));
        ((RecipeManagerAccessor)this.recipeManager).setByName((Map<ResourceLocation, RecipeHolder<?>>)ImmutableMap.copyOf(this.byName));
        LOGGER.debug("Added {} recipes to RecipeManager", (Object)this.added);
        LOGGER.debug("Removed {} recipes from RecipeManager", (Object)this.removed);
    }
}

