/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.processing.blaze;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerMovementBehaviour;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import plus.dragons.createdragonsplus.common.processing.blaze.BlazeBlock;
import plus.dragons.createdragonsplus.util.CodeReference;

@CodeReference(value={BlazeBurnerMovementBehaviour.class}, source={"create"}, license={"mit"})
public class BlazeMovementBehaviour
implements MovementBehaviour {
    public void tick(MovementContext context) {
        if (!context.world.isClientSide()) {
            return;
        }
        RandomSource r = context.world.getRandom();
        Vec3 c = context.position;
        Vec3 v = c.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)r, (float)0.125f).multiply(1.0, 0.0, 1.0));
        if (r.nextInt(3) == 0 && context.motion.length() < 0.015625) {
            context.world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, v.x, v.y, v.z, 0.0, 0.0, 0.0);
        }
        LerpedFloat headAngle = this.getHeadAngle(context);
        boolean quickTurn = !Mth.equal((double)context.relativeMotion.length(), (double)0.0);
        headAngle.chase((double)(headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)headAngle.getValue(), (double)this.getTargetAngle(context))), 0.5, quickTurn ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.exp((double)5.0));
        headAngle.tickChaser();
        this.spawnParticles(context.world, context.position, BlazeBlock.getHeatLevelOf(context.state));
    }

    private LerpedFloat getHeadAngle(MovementContext context) {
        if (!(context.temporaryData instanceof LerpedFloat)) {
            context.temporaryData = LerpedFloat.angular().startWithValue((double)this.getTargetAngle(context));
        }
        return (LerpedFloat)context.temporaryData;
    }

    private float getTargetAngle(MovementContext context) {
        AbstractContraptionEntity abstractContraptionEntity;
        if (!Mth.equal((double)context.relativeMotion.length(), (double)0.0) && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
            float angle = AngleHelper.deg((double)(-Mth.atan2((double)context.relativeMotion.x, (double)context.relativeMotion.z)));
            return cce.getInitialOrientation().getAxis() == Direction.Axis.X ? angle + 180.0f : angle;
        }
        Entity player = Minecraft.getInstance().cameraEntity;
        if (player != null && !player.isInvisible() && context.position != null) {
            Vec3 applyRotation = context.contraption.entity.reverseRotation(player.position().subtract(context.position), 1.0f);
            double dx = applyRotation.x;
            double dz = applyRotation.z;
            return AngleHelper.deg((double)(-Mth.atan2((double)dz, (double)dx))) - 90.0f;
        }
        return 0.0f;
    }

    protected void spawnParticles(Level level, Vec3 pos, BlazeBurnerBlock.HeatLevel heatLevel) {
        assert (level != null);
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource random = level.getRandom();
        Vec3 smokePos = pos.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)random, (float)0.125f).multiply(1.0, 0.0, 1.0));
        if (random.nextInt(4) != 0) {
            return;
        }
        if (random.nextInt(8) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, smokePos.x, smokePos.y, smokePos.z, 0.0, 0.0, 0.0);
        }
        double yMotion = random.nextDouble() * (double)0.0125f;
        Vec3 flamePos = pos.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)random, (float)0.5f).multiply(1.0, 0.25, 1.0).normalize().scale(0.5 + random.nextDouble() * 0.25)).add(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, flamePos.x, flamePos.y, flamePos.z, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, flamePos.x, flamePos.y, flamePos.z, 0.0, yMotion, 0.0);
        }
    }
}

