/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.mixins;

import mirsario.cameraoverhaul.ScreenShakes;
import mirsario.cameraoverhaul.configuration.Configuration;
import net.minecraft.world.level.Explosion;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin {
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;
    @Shadow
    @Final
    private float radius;

    @Inject(method={"finalizeExplosion(Z)V"}, at={@At(value="RETURN")})
    private void finalizeExplosion(boolean spawnParticles, CallbackInfo ci) {
        ScreenShakes.Slot shake = ScreenShakes.createDirect();
        shake.position.set(this.x, this.y, this.z);
        shake.radius = this.radius * 10.0f;
        shake.trauma = (float)Configuration.get().general.explosionTrauma;
        shake.lengthInSeconds = 2.0f;
    }
}

