/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul;

import mirsario.cameraoverhaul.CameraContext;
import mirsario.cameraoverhaul.TimeSystem;
import mirsario.cameraoverhaul.configuration.ConfigData;
import mirsario.cameraoverhaul.configuration.Configuration;
import mirsario.cameraoverhaul.utilities.Transform;
import org.joml.Math;
import org.joml.SimplexNoise;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class ScreenShakes {
    private static final Slot dummyInstance = new Slot();
    private static final Vector3d calculatedOffset = new Vector3d();
    private static final Slot[] instances = new Slot[64];
    private static long instanceMask;

    private ScreenShakes() {
    }

    public static void onCameraUpdate(CameraContext context, double deltaTime) {
        ConfigData cfg = Configuration.get();
        ScreenShakes.getNoiseAtPosition(context.transform.position, calculatedOffset);
        calculatedOffset.mul(cfg.general.screenShakesMaxIntensity);
    }

    public static void modifyCameraTransform(Transform transform) {
        transform.eulerRot.add((Vector3dc)calculatedOffset);
    }

    private static int extractIndex(long handle) {
        return (int)handle;
    }

    private static int extractVersion(long handle) {
        return (int)(handle >> 32);
    }

    private static long constructHandle(int index, int version) {
        return (long)index | (long)version << 32;
    }

    private static boolean isHandleValid(long handle) {
        return handle != 0L && ScreenShakes.instances[ScreenShakes.extractIndex((long)handle)].version == ScreenShakes.extractVersion(handle);
    }

    public static Slot get(long handle) {
        return ScreenShakes.isHandleValid(handle) ? instances[ScreenShakes.extractIndex(handle)] : dummyInstance;
    }

    public static Slot createDirect() {
        return ScreenShakes.get(ScreenShakes.create());
    }

    public static long create() {
        if (instanceMask == Long.MAX_VALUE) {
            return 0L;
        }
        int index = Long.numberOfTrailingZeros(instanceMask ^ 0xFFFFFFFFFFFFFFFFL);
        if (instances[index] == null) {
            ScreenShakes.instances[index] = new Slot();
        }
        short version = ScreenShakes.instances[index].version;
        instanceMask |= 1L << index;
        instances[index].setDefaults();
        return ScreenShakes.constructHandle(index, version);
    }

    public static long validate(long handle) {
        return !ScreenShakes.isHandleValid(handle) ? ScreenShakes.create() : handle;
    }

    public static long recreate(long handle) {
        if (!ScreenShakes.isHandleValid(handle)) {
            return ScreenShakes.create();
        }
        ScreenShakes.get(handle).setDefaults();
        return handle;
    }

    public static void getNoiseAtPosition(Vector3d position, Vector3d noise) {
        ConfigData cfg = Configuration.get();
        long mask = instanceMask;
        double time = TimeSystem.getTime();
        float sampleBase = (float)(time * cfg.general.screenShakesMaxFrequency);
        float total = 0.0f;
        noise.set(0.0);
        while (mask != 0L) {
            float progress;
            int index = Long.numberOfTrailingZeros(mask);
            mask &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
            Slot ss = instances[index];
            float f = progress = (double)ss.lengthInSeconds > 0.0 ? (float)Math.clamp((double)((time - ss.startTime) / (double)ss.lengthInSeconds), (double)0.0, (double)1.0) : 1.0f;
            if (progress >= 1.0f) {
                instanceMask &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
                ss.version = (short)(ss.version + 1);
                continue;
            }
            float decay = 1.0f - progress;
            float intensity = Math.clamp((float)ss.trauma, (float)0.0f, (float)1.0f) * (decay * decay);
            if (ss.hasPosition()) {
                float distance = (float)position.distance((Vector3dc)ss.position);
                float distanceFactor = 1.0f - Math.min((float)1.0f, (float)(distance / ss.radius));
                intensity *= distanceFactor * distanceFactor;
            }
            if (intensity <= 0.0f || !Float.isFinite(intensity)) continue;
            float sampleStep = sampleBase * ss.frequency;
            noise.add((double)(SimplexNoise.noise((float)sampleStep, (float)-69.0f) * intensity), (double)(SimplexNoise.noise((float)sampleStep, (float)-420.0f) * intensity), (double)(SimplexNoise.noise((float)sampleStep, (float)-1337.0f) * intensity));
            total += intensity;
        }
        if ((double)total > 1.0) {
            noise.div((double)total);
        }
    }

    public static final class Slot {
        public float trauma;
        public float radius;
        public float frequency;
        public float lengthInSeconds;
        public final Vector3d position = new Vector3d(Double.POSITIVE_INFINITY);
        double startTime;
        short version = 1;

        public boolean hasPosition() {
            return this.position.isFinite();
        }

        private Slot() {
        }

        public void setDefaults() {
            this.trauma = 0.5f;
            this.radius = 10.0f;
            this.frequency = 1.0f;
            this.lengthInSeconds = 2.0f;
            this.position.set(Double.POSITIVE_INFINITY);
            this.startTime = TimeSystem.getTime();
        }
    }
}

