/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.test;

import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.init.MultiblockHatches;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.test.framework.MIGameTest;
import aztech.modern_industrialization.test.framework.MIGameTestHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MultiblockTests {
    @MIGameTest
    public void largeTankEmitsRedstone(MIGameTestHelper helper) {
        BlockPos controllerPos = new BlockPos(3, 1, 2);
        helper.setBlock(controllerPos, MultiblockMachines.LARGE_TANK.asBlock());
        LargeTankMultiblockBlockEntity largeTank = (LargeTankMultiblockBlockEntity)helper.getBlockEntity(controllerPos);
        largeTank.createShapeMatcher().buildMultiblock((Level)helper.getLevel());
        BlockPos comparatorPos0 = new BlockPos(3, 1, 1);
        helper.setBlock(comparatorPos0.below(), Blocks.STONE);
        helper.setBlock(comparatorPos0, (BlockState)Blocks.COMPARATOR.defaultBlockState().setValue((Property)ComparatorBlock.FACING, (Comparable)Direction.SOUTH));
        BlockPos hatchPos1 = new BlockPos(3, 0, 4);
        helper.setBlock(hatchPos1, MultiblockHatches.LARGE_TANK.asBlock());
        BlockPos comparatorPos1 = new BlockPos(3, 0, 5);
        helper.setBlock(comparatorPos1, Blocks.COMPARATOR);
        BlockPos hatchPos2 = new BlockPos(4, 0, 2);
        helper.setBlock(hatchPos2, MultiblockHatches.LARGE_TANK.asBlock());
        BlockPos comparatorPos2 = new BlockPos(5, 0, 2);
        helper.setBlock(comparatorPos2, (BlockState)Blocks.COMPARATOR.defaultBlockState().setValue((Property)ComparatorBlock.FACING, (Comparable)Direction.WEST));
        BlockPos redstonePos = new BlockPos(6, 0, 2);
        helper.setBlock(redstonePos, Blocks.REDSTONE_WIRE);
        helper.startSequence().thenIdle(1).thenExecute(() -> {
            helper.assertBlockProperty(comparatorPos0, (Property)ComparatorBlock.POWERED, Boolean.valueOf(false));
            helper.assertBlockProperty(comparatorPos1, (Property)ComparatorBlock.POWERED, Boolean.valueOf(false));
            helper.assertBlockProperty(comparatorPos2, (Property)ComparatorBlock.POWERED, Boolean.valueOf(false));
            helper.assertBlockProperty(redstonePos, (Property)RedStoneWireBlock.POWER, Integer.valueOf(0));
        }).thenExecute(() -> largeTank.getExposedFluidHandler().fill(new FluidStack((Fluid)Fluids.WATER, 1), IFluidHandler.FluidAction.EXECUTE)).thenIdle(3).thenExecute(() -> {
            helper.assertBlockProperty(comparatorPos0, (Property)ComparatorBlock.POWERED, Boolean.valueOf(true));
            helper.assertBlockProperty(comparatorPos1, (Property)ComparatorBlock.POWERED, Boolean.valueOf(true));
            helper.assertBlockProperty(comparatorPos2, (Property)ComparatorBlock.POWERED, Boolean.valueOf(true));
            helper.assertBlockProperty(redstonePos, (Property)RedStoneWireBlock.POWER, Integer.valueOf(1));
        }).thenExecute(() -> largeTank.getExposedFluidHandler().fill(new FluidStack((Fluid)Fluids.WATER, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE)).thenIdle(3).thenExecute(() -> {
            helper.assertBlockProperty(comparatorPos0, (Property)ComparatorBlock.POWERED, Boolean.valueOf(true));
            helper.assertBlockProperty(comparatorPos1, (Property)ComparatorBlock.POWERED, Boolean.valueOf(true));
            helper.assertBlockProperty(comparatorPos2, (Property)ComparatorBlock.POWERED, Boolean.valueOf(true));
            helper.assertBlockProperty(redstonePos, (Property)RedStoneWireBlock.POWER, Integer.valueOf(15));
        }).thenExecute(() -> helper.setBlock(hatchPos1.above(2), Blocks.AIR)).thenIdle(3).thenExecute(() -> {
            helper.assertBlockProperty(comparatorPos0, (Property)ComparatorBlock.POWERED, Boolean.valueOf(false));
            helper.assertBlockProperty(comparatorPos1, (Property)ComparatorBlock.POWERED, Boolean.valueOf(false));
            helper.assertBlockProperty(comparatorPos2, (Property)ComparatorBlock.POWERED, Boolean.valueOf(false));
            helper.assertBlockProperty(redstonePos, (Property)RedStoneWireBlock.POWER, Integer.valueOf(0));
        }).thenSucceed();
    }
}

