/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.gui;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.network.machines.MachineComponentSyncPacket;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MachineMenuServer
extends MachineMenuCommon {
    public final MachineBlockEntity blockEntity;
    protected final List<Object> trackedData;

    public MachineMenuServer(int syncId, Inventory playerInventory, MachineBlockEntity blockEntity, MachineGuiParameters guiParams) {
        super(syncId, playerInventory, blockEntity.getInventory(), guiParams, blockEntity.guiComponents);
        this.blockEntity = blockEntity;
        this.trackedData = new ArrayList<Object>();
        for (GuiComponentServer component : blockEntity.guiComponents) {
            this.trackedData.add(component.extractData());
        }
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        this.blockEntity.guiComponents.forEachIndexed((i, component) -> {
            Object newData = component.extractData();
            if (!Objects.equals(this.trackedData.get((int)i), newData)) {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.blockEntity.getLevel().registryAccess());
                component.getType().dataCodec().encode((Object)buf, newData);
                byte[] bytes = new byte[buf.writerIndex()];
                buf.readBytes(bytes);
                new MachineComponentSyncPacket(this.containerId, (int)i, bytes).sendToClient((ServerPlayer)this.playerInventory.player);
                this.trackedData.set((int)i, newData);
                buf.release();
            }
        });
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this.blockEntity, (Player)player);
    }

    @Override
    public void readClientComponentSyncData(int componentIndex, RegistryFriendlyByteBuf buf) {
        throw new UnsupportedOperationException("Data can only be read on the client side!");
    }
}

