/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.FuelBurningComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluids;

public class SteamBoilerMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable {
    private final ShapeTemplate shapeTemplate;
    private final IsActiveComponent isActiveComponent;
    private final RedstoneControlComponent redstoneControl;
    private final MultiblockInventoryComponent inventory;
    private final SteamHeaterComponent steamHeater;
    private final FuelBurningComponent fuelBurning;
    public final boolean highPressure;

    public SteamBoilerMultiblockBlockEntity(BEP bep, ShapeTemplate shapeTemplate, String name, long maxEuProduction, boolean highPressure) {
        super(bep, new MachineGuiParameters.Builder(name, false).build(), new OrientationComponent.Params(false, false, false));
        this.highPressure = highPressure;
        this.isActiveComponent = new IsActiveComponent();
        this.shapeTemplate = shapeTemplate;
        this.inventory = new MultiblockInventoryComponent();
        this.redstoneControl = new RedstoneControlComponent();
        this.steamHeater = new SteamHeaterComponent(2500.0, maxEuProduction, maxEuProduction / 32L, !highPressure, highPressure, true);
        this.fuelBurning = new FuelBurningComponent(this.steamHeater, 2L);
        this.registerComponents(this.isActiveComponent, this.steamHeater, this.fuelBurning, this.redstoneControl);
        ProgressBar.Params PROGRESS_BAR = new ProgressBar.Params(82, 30, "furnace", 14, 14, true);
        TemperatureBar.Params TEMPERATURE_BAR = new TemperatureBar.Params(42, 55, 2500);
        this.registerGuiComponent(new ProgressBar(PROGRESS_BAR, () -> Float.valueOf((float)this.fuelBurning.getBurningProgress())));
        this.registerGuiComponent(new TemperatureBar(TEMPERATURE_BAR, () -> (int)this.steamHeater.getTemperature()));
        this.registerGuiComponent(new SlotPanel(this).withRedstoneControl(this.redstoneControl));
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        if (shapeMatcher.isMatchSuccessful()) {
            this.inventory.rebuild(shapeMatcher);
        }
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.shapeTemplate;
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    public MachineModelClientData getMachineModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActiveComponent.isActive);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            this.link();
            if (this.shapeValid.shapeValid) {
                if (this.redstoneControl.doAllowNormalOperation(this)) {
                    this.steamHeater.tick(this.inventory.getFluidInputs(), this.inventory.getFluidOutputs());
                    this.fuelBurning.tick(this.inventory.getItemInputs(), this.inventory.getFluidInputs(), true);
                    this.isActiveComponent.updateActive(this.fuelBurning.isBurning(), this);
                } else {
                    this.steamHeater.tickDisabled();
                    this.fuelBurning.tick(this.inventory.getItemInputs(), this.inventory.getFluidInputs(), false);
                    this.isActiveComponent.updateActive(false, this);
                }
            } else {
                this.steamHeater.tickDisabled();
                this.fuelBurning.clearActiveFuel();
                this.isActiveComponent.updateActive(false, this);
            }
            this.setChanged();
        }
    }

    @Override
    public List<Component> getTooltips() {
        List<Component> tooltips = this.fuelBurning.getTooltips();
        tooltips.add((Component)new MITooltips.Line(MIText.ContinuousOperation).build());
        if (this.highPressure) {
            tooltips.add((Component)new MITooltips.Line(MIText.AcceptLowOrHighPressure).arg(MIFluids.HIGH_PRESSURE_WATER).arg(MIFluids.HIGH_PRESSURE_HEAVY_WATER).build());
        } else {
            tooltips.add((Component)new MITooltips.Line(MIText.AcceptLowOrHighPressure).arg(Fluids.WATER).arg(MIFluids.HEAVY_WATER).build());
        }
        return tooltips;
    }
}

