/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.CableTierHolder;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EnergyHatch
extends HatchBlockEntity
implements EnergyComponentHolder,
CableTierHolder {
    private final boolean input;
    private final CableTier tier;
    private final EnergyComponent energy;
    private final MIEnergyStorage insertable;
    private final MIEnergyStorage extractable;

    public EnergyHatch(BEP bep, MachineGuiParameters guiParams, boolean input, CableTier tier) {
        super(bep, guiParams, input ? OrientationComponent.Params.noFacingNoOutput() : OrientationComponent.Params.noFacing(false, false));
        this.input = input;
        this.tier = tier;
        this.energy = new EnergyComponent((BlockEntity)this, 600L * tier.getEu());
        this.insertable = this.energy.buildInsertable(tier2 -> tier2 == tier);
        this.extractable = this.energy.buildExtractable(tier2 -> tier2 == tier);
        EnergyBar.Params energyBarParams = new EnergyBar.Params(76, 39);
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new EnergyBar(energyBarParams, this.energy::getEu, this.energy::getCapacity);
        this.registerGuiComponent(guiComponentServerArray);
        this.registerComponents(this.energy);
    }

    @Override
    public HatchType getHatchType() {
        return this.input ? HatchTypes.ENERGY_INPUT : HatchTypes.ENERGY_OUTPUT;
    }

    @Override
    public boolean upgradesToSteel() {
        return false;
    }

    @Override
    public CableTier getCableTier() {
        return this.tier;
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    @Override
    public void appendEnergyInputs(List<EnergyComponent> list) {
        if (this.input) {
            list.add(this.energy);
        }
    }

    @Override
    public void appendEnergyOutputs(List<EnergyComponent> list) {
        if (!this.input) {
            list.add(this.energy);
        }
    }

    @Override
    protected void tickTransfer() {
        if (!this.input) {
            EnergyHelper.autoOutput((MachineBlockEntity)this, this.orientation, this.tier, this.extractable);
        }
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
            EnergyHatch eh = (EnergyHatch)be;
            if (eh.input) {
                return eh.insertable;
            }
            if (eh.orientation.outputDirection == direction) {
                return eh.extractable;
            }
            return null;
        }));
    }
}

