/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.FuelBurningComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;

public class BoilerMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    public static final int WATER_SLOT_X = 50;
    public static final int WATER_SLOT_Y = 32;
    public static final int INPUT_SLOT_X = 15;
    public static final int INPUT_SLOT_Y = 32;
    public static final int OUTPUT_SLOT_X = 134;
    public static final int OUTPUT_SLOT_Y = 32;
    private final MIInventory inventory;
    public final boolean bronze;
    private final SteamHeaterComponent steamHeater;
    private final FuelBurningComponent fuelBurning;
    protected IsActiveComponent isActiveComponent;

    public BoilerMachineBlockEntity(BEP bep, boolean bronze) {
        super(bep, new MachineGuiParameters.Builder(bronze ? "bronze_boiler" : "steel_boiler", true).backgroundHeight(180).build(), new OrientationComponent.Params(false, false, false));
        int capacity = 1000 * (bronze ? 8 : 16);
        List<ConfigurableItemStack> itemStacks = Collections.singletonList(ConfigurableItemStack.standardInputSlot());
        SlotPositions itemPositions = new SlotPositions.Builder().addSlot(15, 32).build();
        List<ConfigurableFluidStack> fluidStacks = Arrays.asList(ConfigurableFluidStack.lockedInputSlot(capacity, (Fluid)Fluids.WATER), ConfigurableFluidStack.lockedOutputSlot(capacity, MIFluids.STEAM.asFluid()));
        SlotPositions fluidPositions = new SlotPositions.Builder().addSlot(50, 32).addSlot(134, 32).build();
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        this.bronze = bronze;
        this.steamHeater = new SteamHeaterComponent(1500.0, bronze ? 8L : 16L, 8L, true, false, false);
        this.fuelBurning = new FuelBurningComponent(this.steamHeater, 1L);
        this.isActiveComponent = new IsActiveComponent();
        ProgressBar.Params progressParams = new ProgressBar.Params(133, 50, "furnace", 14, 14, true);
        TemperatureBar.Params temperatureParams = new TemperatureBar.Params(42, 75, 1500);
        this.registerGuiComponent(new ProgressBar(progressParams, () -> Float.valueOf((float)this.fuelBurning.getBurningProgress())));
        this.registerGuiComponent(new TemperatureBar(temperatureParams, () -> (int)this.steamHeater.getTemperature()));
        this.registerComponents(this.inventory, this.isActiveComponent, this.steamHeater, this.fuelBurning);
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.bronze ? MachineCasings.BRICKED_BRONZE : MachineCasings.BRICKED_STEEL);
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        this.steamHeater.tick(Collections.singletonList(this.inventory.getFluidStacks().get(0)), Collections.singletonList(this.inventory.getFluidStacks().get(1)));
        this.fuelBurning.tick(Collections.singletonList(this.inventory.getItemStacks().get(0)), Collections.emptyList(), true);
        for (Direction direction : Direction.values()) {
            this.getInventory().autoExtractFluids(this.level, this.worldPosition, direction);
        }
        this.isActiveComponent.updateActive(this.fuelBurning.isBurning(), this);
        this.setChanged();
    }

    @Override
    public List<Component> getTooltips() {
        return this.fuelBurning.getTooltips();
    }

    @Override
    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        IFluidHandler waterSlotHandler;
        FluidActionResult result;
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty() && (result = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)(waterSlotHandler = new MIFluidStorage(this.inventory.getFluidStacks().subList((int)0, (int)1)).fluidHandler), (IItemHandler)new PlayerInvWrapper(player.getInventory()), (int)Integer.MAX_VALUE, (Player)player, (boolean)true)).isSuccess()) {
            player.setItemInHand(hand, result.getResult());
            return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return super.useItemOn(player, hand, face);
    }
}

