/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.fluid;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.fluid.MIFluidBlock;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jspecify.annotations.Nullable;

public class MIFluidType
extends FluidType {
    private final DeferredBlock<MIFluidBlock> fluidBlock;

    public MIFluidType(DeferredBlock<MIFluidBlock> fluidBlock, FluidType.Properties properties) {
        super(properties);
        this.fluidBlock = fluidBlock;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private @Nullable ResourceLocation textureLocation;

            public ResourceLocation getStillTexture() {
                if (this.textureLocation == null) {
                    this.textureLocation = MI.id("fluid/%s_still".formatted(MIFluidType.this.fluidBlock.getId().getPath()));
                }
                return this.textureLocation;
            }

            public ResourceLocation getFlowingTexture() {
                return IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getFlowingTexture();
            }
        });
    }
}

