/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.model;

import aztech.modern_industrialization.machines.models.MachineCasing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public record MachineModelProperties(MachineCasing casing, Map<String, ResourceLocation> defaultOverlays, boolean noOverlayOnOutputSide) {
    public MachineModelProperties(MachineCasing casing, Map<String, ResourceLocation> defaultOverlays, boolean noOverlayOnOutputSide) {
        this.casing = casing;
        this.defaultOverlays = Map.copyOf(defaultOverlays);
        this.noOverlayOnOutputSide = noOverlayOnOutputSide;
    }

    public void addToMachineJson(JsonObject obj) {
        obj.addProperty("casing", this.casing.key.getPath());
        JsonObject defaultOverlays = new JsonObject();
        for (Map.Entry<String, ResourceLocation> entry : this.defaultOverlays.entrySet()) {
            defaultOverlays.addProperty(entry.getKey(), entry.getValue().toString());
        }
        obj.add("default_overlays", (JsonElement)defaultOverlays);
        if (this.noOverlayOnOutputSide) {
            obj.addProperty("no_overlay_on_output_side", Boolean.valueOf(true));
        }
    }

    public static class Builder {
        private final MachineCasing casing;
        private final Map<String, ResourceLocation> defaultOverlays;
        private boolean noOverlayOnOutputSide = false;

        public Builder(MachineCasing casing) {
            this.casing = casing;
            this.defaultOverlays = new HashMap<String, ResourceLocation>();
        }

        public Builder addOverlay(String name, ResourceLocation texture) {
            this.defaultOverlays.put(name, texture);
            return this;
        }

        public Builder noOverlayOnOutputSide() {
            this.noOverlayOnOutputSide = true;
            return this;
        }

        public MachineModelProperties build() {
            return new MachineModelProperties(this.casing, this.defaultOverlays, this.noOverlayOnOutputSide);
        }
    }
}

