/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.multiblocks;

import aztech.modern_industrialization.client.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jspecify.annotations.Nullable;

public class MultiblockErrorHighlight {
    private static final Map<BlockPos, @Nullable BlockState> highlightQueue = new HashMap<BlockPos, BlockState>();
    private static final MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(128));

    public static void init() {
        NeoForge.EVENT_BUS.addListener(MultiblockErrorHighlight::end);
    }

    public static void enqueueHighlight(BlockPos pos, @Nullable BlockState state) {
        highlightQueue.put(pos.immutable(), state);
    }

    private static void end(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        if (highlightQueue.size() > 0) {
            RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.mulPose(event.getModelViewMatrix());
            for (Map.Entry<BlockPos, BlockState> entry : highlightQueue.entrySet()) {
                poseStack.pushPose();
                Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                BlockPos pos = entry.getKey();
                double x = (double)pos.getX() - cameraPos.x;
                double y = (double)pos.getY() - cameraPos.y;
                double z = (double)pos.getZ() - cameraPos.z;
                poseStack.translate(x + 0.25, y + 0.25, z + 0.25);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                BlockState state = entry.getValue();
                if (state == null) {
                    RenderHelper.drawCube(poseStack, (MultiBufferSource)immediate, 1.0f, 0.1953125f, 0.1953125f, 0xF000F0, OverlayTexture.NO_OVERLAY);
                } else {
                    Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, poseStack, (MultiBufferSource)immediate, 0xF000F0, OverlayTexture.NO_OVERLAY);
                }
                poseStack.popPose();
            }
            poseStack.popPose();
            immediate.endBatch();
            highlightQueue.clear();
        }
    }
}

