/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.items;

import aztech.modern_industrialization.items.SteamDrillHooks;
import aztech.modern_industrialization.items.SteamDrillItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import org.apache.commons.lang3.mutable.MutableObject;

public class SteamDrillHighlight {
    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof SteamDrillItem)) {
            return;
        }
        SteamDrillItem drillItem = (SteamDrillItem)item;
        SteamDrillItem.Area area = drillItem.getArea((BlockGetter)player.level(), (Player)player, stack, true);
        if (area == null) {
            return;
        }
        BlockPos origin = area.center();
        MutableObject fullShape = new MutableObject((Object)Shapes.empty());
        SteamDrillItem.forEachMineableBlock((BlockGetter)player.level(), area, (LivingEntity)player, (blockPos, state) -> {
            float destroyProgress = SteamDrillHooks.getDestroyProgressRaw(state, (Player)player, (BlockGetter)player.level(), blockPos);
            if ((double)destroyProgress <= 1.0E-9) {
                return;
            }
            VoxelShape blockShape = state.getShape((BlockGetter)player.level(), blockPos, CollisionContext.of((Entity)event.getCamera().getEntity()));
            blockShape = blockShape.move((double)(blockPos.getX() - origin.getX()), (double)(blockPos.getY() - origin.getY()), (double)(blockPos.getZ() - origin.getZ()));
            fullShape.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)fullShape.getValue()), (VoxelShape)blockShape, (BooleanOp)BooleanOp.OR));
        });
        if (fullShape.getValue() == Shapes.empty()) {
            return;
        }
        LevelRenderer.renderShape((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().getBuffer(RenderType.lines()), (VoxelShape)((VoxelShape)fullShape.getValue()), (double)((double)origin.getX() - event.getCamera().getPosition().x()), (double)((double)origin.getY() - event.getCamera().getPosition().y()), (double)((double)origin.getZ() - event.getCamera().getPosition().z()), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        event.setCanceled(true);
    }
}

