/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.compat.jade;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.client.compat.jade.MIJadeClientPlugin;
import aztech.modern_industrialization.compat.jade.server.MIJadeCommonPlugin;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.FluidHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;

public class PipeComponentProvider
implements IBlockComponentProvider {
    public ResourceLocation getUid() {
        return MI.id("pipe");
    }

    private @Nullable PipeVoxelShape getHitShape(BlockAccessor accessor) {
        PipeBlockEntity pipe = (PipeBlockEntity)accessor.getBlockEntity();
        Vec3 hitPos = ((BlockHitResult)accessor.getHitResult()).getLocation();
        BlockPos blockPos = accessor.getPosition();
        for (PipeVoxelShape partShape : pipe.getPartShapes()) {
            Vec3 posInBlock = hitPos.subtract((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            for (AABB box : partShape.shape.toAabbs()) {
                Vec3 dir;
                if (!box.contains(posInBlock.add(dir = box.getCenter().subtract(posInBlock).normalize().scale(1.0E-4)))) continue;
                return partShape;
            }
        }
        return null;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        PipeVoxelShape shape = this.getHitShape(accessor);
        if (shape != null) {
            CompoundTag tag = accessor.getServerData().getCompound(shape.type.getIdentifier().toString());
            IElementHelper helper = IElementHelper.get();
            if (tag.contains("fluid")) {
                FluidVariant fluid = FluidVariant.fromNbt(tag.getCompound("fluid"), (HolderLookup.Provider)accessor.getLevel().registryAccess());
                long stored = tag.getLong("amount");
                long capacity = tag.getInt("capacity");
                long transfer = tag.getLong("transfer");
                long maxTransfer = tag.getLong("maxTransfer");
                MutableComponent fluidName = IDisplayHelper.get().stripColor(FluidHelper.getFluidName(fluid, true));
                String storedText = MIJadeClientPlugin.getUnicodeMillibuckets(stored, true);
                String capacityText = MIJadeClientPlugin.getUnicodeMillibuckets(capacity, true);
                MutableComponent text = fluid.isBlank() ? Component.translatable((String)"jade.fluid", (Object[])new Object[]{MIText.Empty.text(), Component.literal((String)capacityText).withStyle(ChatFormatting.GRAY)}) : (accessor.showDetails() ? Component.translatable((String)"jade.fluid2", (Object[])new Object[]{fluidName.withStyle(ChatFormatting.WHITE), Component.literal((String)storedText).withStyle(ChatFormatting.WHITE), capacityText}).withStyle(ChatFormatting.GRAY) : Component.translatable((String)"jade.fluid", (Object[])new Object[]{fluidName, storedText}));
                ProgressStyle progressStyle = helper.progressStyle().overlay(helper.fluid(MIJadeCommonPlugin.fluidStack(fluid, stored)));
                tooltip.add(helper.progress(MIJadeClientPlugin.ratio(stored, capacity), (Component)text, progressStyle, BoxStyle.getNestedBox(), true));
                if (!fluid.isBlank()) {
                    String transferText = MIJadeClientPlugin.getUnicodeMillibuckets(transfer, true);
                    String maxTransferText = MIJadeClientPlugin.getUnicodeMillibuckets(maxTransfer, true);
                    Object maxText = accessor.showDetails() ? MIJadeClientPlugin.textAndRatio((Component)MIText.NetworkTransfer.text(), transferText, maxTransferText) : MIText.NetworkTransfer.text().append(" ").append((Component)Component.literal((String)transferText));
                    tooltip.add(helper.progress(MIJadeClientPlugin.ratio(transfer, maxTransfer), maxText, progressStyle, BoxStyle.getNestedBox(), true));
                }
            }
            if (tag.contains("eu")) {
                long stored = tag.getLong("eu");
                long capacity = tag.getLong("maxEu");
                long transfer = tag.getLong("transfer");
                long maxTransfer = tag.getLong("maxTransfer");
                tooltip.add(helper.progress(MIJadeClientPlugin.ratio(stored, capacity), (Component)Component.literal((String)"").append((Component)Component.literal((String)IDisplayHelper.get().humanReadableNumber((double)stored, " EU", false)).withStyle(ChatFormatting.WHITE)).append(" / ").append((Component)Component.literal((String)IDisplayHelper.get().humanReadableNumber((double)capacity, " EU", false))).withStyle(ChatFormatting.GRAY), helper.progressStyle().color(-5636096, -10092544).textColor(-1), BoxStyle.getNestedBox(), true));
                tooltip.add(List.of(helper.text((Component)MIText.NetworkTier.text().withStyle(ChatFormatting.WHITE)), helper.spacer(10, 0), helper.text((Component)MIPipes.ELECTRICITY_PIPE_TIER.get(MIPipes.INSTANCE.getPipeItem((PipeNetworkType)shape.type).type).longEnglishName().withStyle(MITooltips.NUMBER_TEXT)).align(IElement.Align.CENTER)));
                tooltip.add(helper.progress(MIJadeClientPlugin.ratio(transfer, maxTransfer), MIJadeClientPlugin.textAndRatio((Component)MIText.NetworkTransfer.text(), String.valueOf(IDisplayHelper.get().humanReadableNumber((double)transfer, "", false)), String.valueOf(IDisplayHelper.get().humanReadableNumber((double)maxTransfer, " EU/t", false))), helper.progressStyle().color(-5636096, -10092544).textColor(-1), BoxStyle.getNestedBox(), true));
            }
            if (tag.contains("items")) {
                long items = tag.getLong("items");
                int pulse = tag.getInt("pulse");
                double delay = (double)(60 - pulse) / 20.0;
                double maxDelay = 3.0;
                tooltip.add(helper.progress(MIJadeClientPlugin.ratio(delay, maxDelay), MIJadeClientPlugin.textAndRatio((Component)MIText.NetworkDelay.text(), String.valueOf(IDisplayHelper.get().humanReadableNumber(delay + 0.3, "", false)), String.valueOf(IDisplayHelper.get().humanReadableNumber(maxDelay, " s", false))), helper.progressStyle().color(-11958, -3365061).textColor(-1), BoxStyle.getNestedBox(), false).tag(MI.id("pipe/items/delay")));
                tooltip.add(List.of(helper.text((Component)MIText.NetworkMovedItems.text().withStyle(ChatFormatting.WHITE)), helper.spacer(10, 0), helper.text((Component)Component.literal((String)("" + items)).withStyle(MITooltips.NUMBER_TEXT)).align(IElement.Align.CENTER)));
            }
        }
    }
}

