/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.render.ChatMessageIndicator;
import mod.crend.autohud.render.ComponentRenderer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;

public class AutoHudRenderer {
    public static boolean inRender;
    public static float tickDelta;
    public static float alpha;
    public static float globalOffsetX;
    public static float globalOffsetY;
    public static boolean foodIsRenderedWithMountHealth;
    public static List<Component> active;

    public static boolean shouldRenderHotbarItems() {
        return !AutoHud.targetHotbar || !Components.Hotbar.fullyHidden() || AutoHud.config.animationFade() && AutoHud.config.getHotbarItemsMaximumFade() > 0.0f || !AutoHud.config.animationFade() && AutoHud.config.animationMove();
    }

    public static int modifyArgb(int argb) {
        int oldAlpha = argb >> 24;
        if ((oldAlpha & 0xFC) == 0) {
            oldAlpha = 255;
        }
        return Math.round(alpha * (float)oldAlpha) << 24 | argb & 0xFFFFFF;
    }

    public static int getArgb() {
        return Math.round(alpha * 255.0f) << 24;
    }

    public static void injectTransparency() {
        if (inRender) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
    }

    public static void startRender(GuiGraphics context, DeltaTracker renderTickCounter) {
        inRender = true;
        tickDelta = renderTickCounter.getGameTimeDeltaPartialTick(true);
        active.clear();
    }

    public static void renderChatMessageIndicator(GuiGraphics context, DeltaTracker ignored) {
        if (Components.ChatIndicator.config.active() && !Components.ChatIndicator.fullyHidden()) {
            ComponentRenderer.CHAT_MESSAGE_INDICATOR.wrap(context, ChatMessageIndicator::render);
        }
    }

    public static void endRender() {
        for (Component component : active) {
            System.err.println("Not cleaned up: " + String.valueOf(component.identifier));
        }
        inRender = false;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    static {
        tickDelta = 0.0f;
        alpha = 1.0f;
        globalOffsetX = 0.0f;
        globalOffsetY = 0.0f;
        foodIsRenderedWithMountHealth = false;
        active = new ArrayList<Component>();
    }
}

