/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.mixin;

import mod.crend.autohud.component.ScoreboardHelper;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Scoreboard.class})
public class ScoreboardMixin {
    @Inject(method={"onObjectiveChanged(Lnet/minecraft/world/scores/Objective;)V"}, at={@At(value="HEAD")})
    public void autoHud$onObjectiveUpdate(Objective objective, CallbackInfo ci) {
        ScoreboardHelper.onObjectiveUpdate(objective);
    }

    @Inject(method={"onScoreChanged(Lnet/minecraft/world/scores/ScoreHolder;Lnet/minecraft/world/scores/Objective;Lnet/minecraft/world/scores/Score;)V"}, at={@At(value="HEAD")})
    public void autoHud$onPlayerScoreUpdate(ScoreHolder scoreHolder, Objective objective, Score score, CallbackInfo ci) {
        ScoreboardHelper.onPlayerScoreUpdate(scoreHolder, objective, score);
    }

    @Inject(method={"onPlayerScoreRemoved(Lnet/minecraft/world/scores/ScoreHolder;Lnet/minecraft/world/scores/Objective;)V"}, at={@At(value="HEAD")})
    public void autoHud$onPlayerScoreRemoved(ScoreHolder scoreHolder, Objective objective, CallbackInfo ci) {
        ScoreboardHelper.onPlayerScoreRemove(scoreHolder.getScoreboardName(), objective);
    }

    @Inject(method={"onPlayerRemoved(Lnet/minecraft/world/scores/ScoreHolder;)V"}, at={@At(value="HEAD")})
    public void autoHud$onPlayerRemoved(ScoreHolder scoreHolder, CallbackInfo ci) {
        ScoreboardHelper.onPlayerScoreRemove(scoreHolder.getScoreboardName());
    }

    @Inject(method={"onScoreLockChanged(Lnet/minecraft/world/scores/ScoreHolder;Lnet/minecraft/world/scores/Objective;)V"}, at={@At(value="HEAD")})
    public void autoHud$onPlayerScoreReset(ScoreHolder scoreHolder, Objective objective, CallbackInfo ci) {
        ScoreboardHelper.onPlayerScoreRemove(scoreHolder.getScoreboardName(), objective);
    }

    @Inject(method={"addPlayerToTeam(Ljava/lang/String;Lnet/minecraft/world/scores/PlayerTeam;)Z"}, at={@At(value="RETURN")})
    public void autoHud$onPlayerAddedToTeam(String playerName, PlayerTeam teamAddedTo, CallbackInfoReturnable<Boolean> ci) {
        ScoreboardHelper.onPlayerAddedToTeam(playerName, teamAddedTo);
    }

    @Inject(method={"removePlayerFromTeam(Ljava/lang/String;Lnet/minecraft/world/scores/PlayerTeam;)V"}, at={@At(value="TAIL")})
    public void autoHud$onPlayerRemovedFromTeam(String playerName, PlayerTeam teamRemovedFrom, CallbackInfo ci) {
        ScoreboardHelper.onPlayerRemovedFromTeam(playerName, teamRemovedFrom);
    }
}

