/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component.state;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectIntMutablePair;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.state.ValueComponentState;
import mod.crend.autohud.mixin.TeamMixinAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;

public class ScoreboardComponentState
extends ValueComponentState<Objective> {
    net.minecraft.network.chat.Component cachedDisplayName;
    Map<String, Pair<PlayerTeam, Integer>> cachedTeams = new HashMap<String, Pair<PlayerTeam, Integer>>();
    Map<String, Pair<String, Integer>> cachedPlayerScores = new HashMap<String, Pair<String, Integer>>();

    public ScoreboardComponentState(Component component) {
        super(component, ScoreboardComponentState::createObjective, true);
        this.collectPlayerScores((Objective)this.oldValue);
    }

    private static Objective createObjective() {
        if (Minecraft.getInstance().level == null || Minecraft.getInstance().player == null) {
            return null;
        }
        Scoreboard scoreboard = Minecraft.getInstance().level.getScoreboard();
        PlayerTeam playerTeam = Minecraft.getInstance().player.getTeam();
        if (playerTeam != null && playerTeam.getColor().isColor()) {
            return scoreboard.getDisplayObjective(DisplaySlot.teamColorToSlot((ChatFormatting)playerTeam.getColor()));
        }
        return scoreboard.getDisplayObjective(DisplaySlot.SIDEBAR);
    }

    @Override
    protected void onUpdateReveal(Objective newObjective) {
        if (!Objects.equals(newObjective, this.oldValue)) {
            this.collectPlayerScores(newObjective);
        }
    }

    private void collectPlayerScores(Objective objective) {
        if (objective == null) {
            return;
        }
        this.cachedTeams.clear();
        this.cachedPlayerScores.clear();
        this.cachedDisplayName = objective.getDisplayName();
        objective.getScoreboard().listPlayerScores(objective).forEach(scoreboardEntry -> this.addPlayerScoreAndTeam(ScoreHolder.forNameOnly((String)scoreboardEntry.owner()), objective, scoreboardEntry.value()));
    }

    private void addPlayerScoreAndTeam(ScoreHolder scoreHolder, Objective objective, int score) {
        String playerName = scoreHolder.getScoreboardName();
        PlayerTeam playerTeam = objective.getScoreboard().getPlayerTeam(playerName);
        String teamName = playerTeam == null ? null : playerTeam.getName();
        this.cachedPlayerScores.put(playerName, (Pair<String, Integer>)new ObjectIntMutablePair((Object)teamName, score));
        if (teamName == null) {
            return;
        }
        if (this.cachedTeams.containsKey(teamName)) {
            Pair<PlayerTeam, Integer> teamEntry = this.cachedTeams.get(teamName);
            teamEntry.right((Object)((Integer)teamEntry.right() + 1));
        } else {
            this.cachedTeams.put(teamName, (Pair<PlayerTeam, Integer>)new ObjectIntMutablePair((Object)ScoreboardComponentState.copyTeam(playerTeam), 1));
        }
    }

    public void updateObjectiveDisplayName(Objective objective) {
        net.minecraft.network.chat.Component newDisplayName;
        if (Objects.equals(this.oldValue, objective) && !ScoreboardComponentState.isTextEqual(newDisplayName = objective.getDisplayName(), this.cachedDisplayName)) {
            this.cachedDisplayName = newDisplayName;
            this.component.revealCombined();
        }
    }

    public void onPlayerScoreUpdate(ScoreHolder scoreHolder, Objective objective, Score score) {
        String playerName = scoreHolder.getScoreboardName();
        if (Objects.equals(this.oldValue, objective)) {
            if (this.cachedPlayerScores.containsKey(playerName)) {
                Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
                if (cachedTeamAndScore.right() == null || ((Integer)cachedTeamAndScore.right()).intValue() != score.value()) {
                    this.component.revealCombined();
                    cachedTeamAndScore.right((Object)score.value());
                }
            } else {
                this.addPlayerScoreAndTeam(scoreHolder, objective, score.value());
                this.component.revealCombined();
            }
        }
    }

    public void onPlayerScoreRemove(String playerName) {
        if (this.cachedPlayerScores.containsKey(playerName)) {
            Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
            if (cachedTeamAndScore.left() != null && this.cachedTeams.containsKey(cachedTeamAndScore.left())) {
                this.onTeamRemovedFromPlayer((PlayerTeam)this.cachedTeams.get(cachedTeamAndScore.left()).left());
            }
            this.cachedPlayerScores.remove(playerName);
        }
    }

    public void onPlayerScoreRemove(String playerName, Objective objective) {
        if (Objects.equals(this.oldValue, objective)) {
            this.onPlayerScoreRemove(playerName);
        }
    }

    public void onTeamRemoved(PlayerTeam team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        boolean revealComponent = false;
        for (Map.Entry<String, Pair<String, Integer>> stringPairEntry : this.cachedPlayerScores.entrySet()) {
            Pair<String, Integer> cachedPair = stringPairEntry.getValue();
            if (!Objects.equals(cachedPair.left(), team.getName())) continue;
            cachedPair.left(null);
            revealComponent = true;
        }
        this.cachedTeams.remove(team.getName());
        if (revealComponent) {
            this.component.revealCombined();
        }
    }

    public void onTeamUpdated(PlayerTeam team) {
        if (this.cachedTeams.isEmpty() || !this.cachedTeams.containsKey(team.getName())) {
            return;
        }
        Pair<PlayerTeam, Integer> cachedTeam = this.cachedTeams.get(team.getName());
        if (!ScoreboardComponentState.isTeamEqual(team, (PlayerTeam)cachedTeam.left())) {
            this.component.revealCombined();
            cachedTeam.left((Object)ScoreboardComponentState.copyTeam(team));
        }
    }

    public void onPlayerAddedToTeam(String playerName, PlayerTeam team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
        if (cachedTeamAndScore == null) {
            return;
        }
        if (!Objects.equals(cachedTeamAndScore.left(), team.getName())) {
            boolean cachedTeamHasDifferences;
            boolean cachedPlayerTeamIsEmpty = cachedTeamAndScore.left() == null;
            Pair<PlayerTeam, Integer> cachedTeam = cachedPlayerTeamIsEmpty ? null : this.cachedTeams.get(cachedTeamAndScore.left());
            boolean bl = cachedTeamHasDifferences = !cachedPlayerTeamIsEmpty && cachedTeam != null && !ScoreboardComponentState.isTeamEqual(team, (PlayerTeam)cachedTeam.left());
            if (cachedPlayerTeamIsEmpty || cachedTeamHasDifferences) {
                if (cachedTeamHasDifferences) {
                    this.onTeamRemovedFromPlayer((PlayerTeam)cachedTeam.left());
                }
                this.component.revealCombined();
                cachedTeamAndScore.left((Object)team.getName());
                this.onTeamAddedToPlayer(team);
            }
        }
    }

    public void onPlayerRemovedFromTeam(String playerName, PlayerTeam team) {
        if (this.cachedPlayerScores.isEmpty()) {
            return;
        }
        Pair<String, Integer> cachedTeamAndScore = this.cachedPlayerScores.get(playerName);
        if (cachedTeamAndScore != null && Objects.equals(cachedTeamAndScore.left(), team.getName())) {
            this.component.revealCombined();
            cachedTeamAndScore.left(null);
            this.onTeamRemovedFromPlayer(team);
        }
    }

    private void onTeamAddedToPlayer(PlayerTeam teamAddedTo) {
        Pair<PlayerTeam, Integer> cachedTeam = this.cachedTeams.get(teamAddedTo.getName());
        if (cachedTeam == null) {
            this.cachedTeams.put(teamAddedTo.getName(), (Pair<PlayerTeam, Integer>)new ObjectIntMutablePair((Object)ScoreboardComponentState.copyTeam(teamAddedTo), 1));
        } else {
            cachedTeam.right((Object)((Integer)cachedTeam.right() + 1));
        }
    }

    private void onTeamRemovedFromPlayer(PlayerTeam teamRemovedFrom) {
        Pair<PlayerTeam, Integer> cachedTeam = this.cachedTeams.get(teamRemovedFrom.getName());
        if (cachedTeam == null) {
            return;
        }
        if ((Integer)cachedTeam.right() - 1 < 1) {
            this.cachedTeams.remove(teamRemovedFrom.getName());
        } else {
            cachedTeam.right((Object)((Integer)cachedTeam.right() - 1));
        }
    }

    private static boolean isTeamEqual(PlayerTeam team, PlayerTeam cachedTeam) {
        if (team == cachedTeam) {
            return true;
        }
        if (team == null || cachedTeam == null) {
            return false;
        }
        return team.getName().equals(cachedTeam.getName()) && team.getColor() == cachedTeam.getColor() && ScoreboardComponentState.isTextEqual(team.getDisplayName(), cachedTeam.getDisplayName()) && ScoreboardComponentState.isTextEqual(team.getPlayerPrefix(), cachedTeam.getPlayerPrefix()) && ScoreboardComponentState.isTextEqual(team.getPlayerSuffix(), cachedTeam.getPlayerSuffix());
    }

    private static boolean isTextEqual(net.minecraft.network.chat.Component left, net.minecraft.network.chat.Component right) {
        boolean rightIsEmpty;
        boolean leftIsEmpty = left == null;
        boolean bl = rightIsEmpty = right == null;
        if (leftIsEmpty && rightIsEmpty) {
            return true;
        }
        if (leftIsEmpty != rightIsEmpty) {
            return false;
        }
        return left.getString().equals(right.getString());
    }

    private static PlayerTeam copyTeam(PlayerTeam team) {
        PlayerTeam copiedTeam = new PlayerTeam(null, team.getName());
        ((TeamMixinAccessor)copiedTeam).autohud$setDisplayName(team.getDisplayName());
        ((TeamMixinAccessor)copiedTeam).autohud$setColor(team.getColor());
        ScoreboardComponentState.teamSetPrefix(copiedTeam, team.getPlayerPrefix());
        ScoreboardComponentState.teamSetSuffix(copiedTeam, team.getPlayerSuffix());
        return copiedTeam;
    }

    private static void teamSetPrefix(PlayerTeam copiedTeam, net.minecraft.network.chat.Component prefix) {
        ((TeamMixinAccessor)copiedTeam).autohud$setPrefix((net.minecraft.network.chat.Component)(prefix == null ? net.minecraft.network.chat.Component.empty() : prefix.copy()));
    }

    private static void teamSetSuffix(PlayerTeam copiedTeam, net.minecraft.network.chat.Component suffix) {
        ((TeamMixinAccessor)copiedTeam).autohud$setSuffix((net.minecraft.network.chat.Component)(suffix == null ? net.minecraft.network.chat.Component.empty() : suffix.copy()));
    }
}

