/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.libbamboo.type.ItemOrTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.phys.HitResult;

public class State {
    Map<Holder<MobEffect>, MobEffectInstance> previousStatusEffects;

    public State(LocalPlayer player) {
        this.initStates(player);
        this.previousStatusEffects = new HashMap<Holder<MobEffect>, MobEffectInstance>();
    }

    public void initStates(LocalPlayer player) {
        Component.getComponents().forEach(component -> component.initState(player));
        Components.ChatIndicator.hideNow();
        AutoHud.apis.forEach(api -> api.initState(player));
    }

    static boolean shouldShowCrosshair() {
        Minecraft client = Minecraft.getInstance();
        if (client.hitResult != null && client.hitResult.getType() != HitResult.Type.MISS) {
            return true;
        }
        if (client.player != null) {
            for (ItemOrTag itemOrTag : AutoHud.config.crosshairAlwaysVisible()) {
                if (!itemOrTag.matches(client.player.getMainHandItem().getItem()) && !itemOrTag.matches(client.player.getOffhandItem().getItem())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isFood(ItemStack itemStack) {
        return itemStack.has(DataComponents.FOOD);
    }

    private static boolean isHealEffect(MobEffectInstance effect) {
        return effect.getEffect() == MobEffects.REGENERATION || effect.getEffect() == MobEffects.HEAL || effect.getEffect() == MobEffects.HEALTH_BOOST || effect.getEffect() == MobEffects.ABSORPTION;
    }

    static boolean canHeal() {
        block3: {
            ItemStack itemStack;
            block2: {
                itemStack = Minecraft.getInstance().player.getMainHandItem();
                if (!State.isFood(itemStack)) break block2;
                List statusEffects = ((FoodProperties)itemStack.get(DataComponents.FOOD)).effects();
                for (FoodProperties.PossibleEffect effect : statusEffects) {
                    if (!State.isHealEffect(effect.effect())) continue;
                    return true;
                }
                break block3;
            }
            if (!(itemStack.getItem() instanceof PotionItem)) break block3;
            Potion potion = (Potion)((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().orElse(Potions.WATER).value();
            for (MobEffectInstance effect : potion.getEffects()) {
                if (!State.isHealEffect(effect)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean revealHotbarOnDurability(ItemStack itemStack) {
        if (itemStack.isDamageableItem() && (double)itemStack.getDamageValue() >= (double)(100 - AutoHud.config.getHotbarDurabilityPercentage()) / 100.0 * (double)itemStack.getMaxDamage() && itemStack.getMaxDamage() - itemStack.getDamageValue() < AutoHud.config.getHotbarDurabilityTotal()) {
            Components.Hotbar.revealCombined();
            Components.Tooltip.revealCombined();
            return true;
        }
        return false;
    }

    public void tick(LocalPlayer player) {
        if (player == null) {
            return;
        }
        Component.tickAll();
        if (AutoHud.config.isHotbarOnLowDurability() && !this.revealHotbarOnDurability(player.getMainHandItem())) {
            this.revealHotbarOnDurability(player.getOffhandItem());
        }
        if (AutoHud.config.revealExperienceTextWithHotbar()) {
            Components.ExperienceLevel.synchronizeFrom(Components.ExperienceBar, Components.Hotbar);
        }
        if (AutoHud.config.statusEffects().active()) {
            if (AutoHud.config.statusEffects().onChange()) {
                HashMap<Holder<MobEffect>, MobEffectInstance> newStatusEffects = new HashMap<Holder<MobEffect>, MobEffectInstance>();
                Map effects = player.getActiveEffectsMap();
                for (Holder effect : effects.keySet()) {
                    MobEffectInstance effectInstance = (MobEffectInstance)effects.get(effect);
                    if (!effectInstance.showIcon() && !AutoHud.config.showHiddenStatusEffects()) continue;
                    if (effectInstance.getDuration() < 5) {
                        Component.get((Holder<MobEffect>)effect).hide();
                    } else if (!this.previousStatusEffects.containsKey(effect)) {
                        Component.get((Holder<MobEffect>)effect).revealFromHidden();
                    } else if (!AutoHud.config.hidePersistentStatusEffects() || !this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get((Holder<MobEffect>)effect).reveal();
                    }
                    newStatusEffects.put((Holder<MobEffect>)effect, new MobEffectInstance(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        } else {
            Component.getStatusEffectComponents().forEach(Component::reveal);
            if (AutoHud.config.hidePersistentStatusEffects()) {
                HashMap<Holder<MobEffect>, MobEffectInstance> newStatusEffects = new HashMap<Holder<MobEffect>, MobEffectInstance>();
                Map effects = player.getActiveEffectsMap();
                for (Holder effect : effects.keySet()) {
                    MobEffectInstance effectInstance = (MobEffectInstance)effects.get(effect);
                    if (!effectInstance.showIcon()) continue;
                    if (this.previousStatusEffects.containsKey(effect) && this.previousStatusEffects.get(effect).equals((Object)effectInstance)) {
                        Component.get((Holder<MobEffect>)effect).hideNow();
                    }
                    newStatusEffects.put((Holder<MobEffect>)effect, new MobEffectInstance(effectInstance));
                }
                this.previousStatusEffects = newStatusEffects;
            }
        }
        AutoHud.apis.forEach(api -> api.tickState(player));
    }
}

