/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.component.state.ScoreboardComponentState;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreHolder;

public class ScoreboardHelper {
    public static void onObjectiveUpdate(Objective objective) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTitleChange()) {
            ScoreboardHelper.getScoreboardComponent().updateObjectiveDisplayName(objective);
        }
    }

    public static void onPlayerScoreUpdate(ScoreHolder scoreHolder, Objective objective, Score score) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnScoreChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerScoreUpdate(scoreHolder, objective, score);
        }
    }

    public static void onPlayerScoreRemove(String playerName) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnScoreChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerScoreRemove(playerName);
        }
    }

    public static void onPlayerScoreRemove(String playerName, Objective objective) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnScoreChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerScoreRemove(playerName, objective);
        }
    }

    public static void onTeamRemoved(PlayerTeam team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onTeamRemoved(team);
        }
    }

    public static void onTeamUpdated(PlayerTeam team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onTeamUpdated(team);
        }
    }

    public static void onPlayerAddedToTeam(String playerName, PlayerTeam team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerAddedToTeam(playerName, team);
        }
    }

    public static void onPlayerRemovedFromTeam(String playerName, PlayerTeam team) {
        if (ScoreboardHelper.canUpdate() && AutoHud.config.shouldRevealScoreboardOnTeamChange()) {
            ScoreboardHelper.getScoreboardComponent().onPlayerRemovedFromTeam(playerName, team);
        }
    }

    private static boolean canUpdate() {
        return Components.Scoreboard.config.active() && Components.Scoreboard.state != null;
    }

    private static ScoreboardComponentState getScoreboardComponent() {
        return (ScoreboardComponentState)Components.Scoreboard.state;
    }
}

