/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.component;

import java.util.function.Supplier;
import mod.crend.autohud.AutoHud;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.State;
import mod.crend.autohud.component.state.BooleanComponentState;
import mod.crend.autohud.component.state.ComponentState;
import mod.crend.autohud.component.state.EnhancedPolicyComponentState;
import mod.crend.autohud.component.state.ItemStackComponentState;
import mod.crend.autohud.component.state.PolicyComponentState;
import mod.crend.autohud.component.state.ScoreboardComponentState;
import mod.crend.autohud.component.state.ValueComponentState;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;

public class Components {
    public static final Supplier<Boolean> TARGET_CHAT = () -> AutoHud.targetChat;
    public static final Supplier<Boolean> TARGET_CROSSHAIR = () -> AutoHud.targetCrosshair;
    public static final Supplier<Boolean> TARGET_EXPERIENCE_BAR = () -> AutoHud.targetExperienceBar;
    public static final Supplier<Boolean> TARGET_HOTBAR = () -> AutoHud.targetHotbar;
    public static final Supplier<Boolean> TARGET_SCOREBOARD = () -> AutoHud.targetScoreboard;
    public static final Supplier<Boolean> TARGET_STATUS_BARS = () -> AutoHud.targetStatusBars;
    public static Component Armor = Component.builder("armor").isTargeted(TARGET_STATUS_BARS).config(AutoHud.config.armor()).inMainHud().state(player -> new EnhancedPolicyComponentState(Armor, () -> ((LocalPlayer)player).getArmorValue(), 20, () -> {
        Equipable equipment;
        Item patt0$temp = player.getMainHandItem().getItem();
        return patt0$temp instanceof Equipable && (equipment = (Equipable)patt0$temp).getEquipmentSlot().isArmor() && player.canTakeItem(player.getMainHandItem());
    }, true)).build();
    public static Component Health = Component.builder("health").isTargeted(TARGET_STATUS_BARS).config(AutoHud.config.health()).stackComponents(Armor).inMainHud().state(player -> new EnhancedPolicyComponentState(Health, () -> Math.round(player.getHealth()), () -> Math.round(player.getMaxHealth()), () -> AutoHud.config.revealBarsWhenHoldingConsumableItem() && State.canHeal())).build();
    public static Component Air = Component.builder("air").isTargeted(TARGET_STATUS_BARS).config(AutoHud.config.air()).inMainHud().state(player -> new PolicyComponentState(Air, () -> ((LocalPlayer)player).getAirSupply(), () -> ((LocalPlayer)player).getMaxAirSupply())).build();
    public static Component Hunger = Component.builder("hunger").isTargeted(TARGET_STATUS_BARS).config(AutoHud.config.hunger()).stackComponents(Air).inMainHud().state(player -> new EnhancedPolicyComponentState(Hunger, () -> player.getFoodData().getFoodLevel(), (Integer)20, () -> AutoHud.config.revealBarsWhenHoldingConsumableItem() && player.getFoodData().getFoodLevel() < 20 && State.isFood(player.getMainHandItem()))).build();
    public static Component MountHealth = Component.builder("mount_health").isTargeted(TARGET_STATUS_BARS).config(AutoHud.config.mountHealth()).stackComponents(Air).inMainHud().build();
    public static Component MountJumpBar = Component.builder("mount_jump_bar").isTargeted(TARGET_STATUS_BARS).config(AutoHud.config.mountJumpBar()).inMainHud().state(player -> new ComponentState(MountJumpBar)).build();
    public static Component ExperienceLevel = Component.builder("experience_level").isTargeted(TARGET_EXPERIENCE_BAR).config(AutoHud.config.experience()).inMainHud().state(player -> new ValueComponentState<Integer>(ExperienceLevel, () -> player.experienceLevel, true)).build();
    public static Component ExperienceBar = Component.builder("experience_bar").isTargeted(TARGET_EXPERIENCE_BAR).config(AutoHud.config.experienceBar()).stackComponents(Health, Hunger, MountHealth, ExperienceLevel).inMainHud().state(player -> new ValueComponentState<Integer>(ExperienceBar, () -> player.totalExperience, true)).build();
    public static Component Hotbar = Component.builder("hotbar").isTargeted(TARGET_HOTBAR).config(AutoHud.config.hotbar()).stackComponents(ExperienceBar).inMainHud().state(player -> new ComponentState(Hotbar)).build();
    public static Component Tooltip = Component.builder("tooltip").isTargeted(TARGET_HOTBAR).config(AutoHud.config.tooltip()).inMainHud().state(player -> new ItemStackComponentState(Tooltip, () -> ((LocalPlayer)player).getMainHandItem(), true)).build();
    public static Component Scoreboard = Component.builder("scoreboard").isTargeted(TARGET_SCOREBOARD).config(AutoHud.config.scoreboard()).state(player -> new ScoreboardComponentState(Scoreboard)).build();
    public static Component Crosshair = Component.builder("crosshair").isTargeted(TARGET_CROSSHAIR).config(AutoHud.config.crosshair()).state(player -> new BooleanComponentState(Crosshair, State::shouldShowCrosshair)).build();
    public static Component Chat = Component.builder("chat").isTargeted(TARGET_CHAT).config(AutoHud.config.chat()).state(player -> new ComponentState(Chat)).build();
    public static Component ChatIndicator = Component.builder("chat_indicator").isTargeted(TARGET_CHAT).config(AutoHud.config.chatIndicator()).state(player -> new ComponentState(ChatIndicator)).register(false).build();
    public static Component ActionBar = Component.builder("action_bar").config(AutoHud.config.actionBar()).state(player -> new ComponentState(ActionBar)).build();
    public static Component BossBar = Component.builder("boss_bar").config(AutoHud.config.bossBar()).state(player -> new ComponentState(BossBar)).build();
}

