/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud.compat;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import mod.crend.autohud.api.AutoHudApi;
import mod.crend.autohud.compat.mixin.cold_sweat.OverlaysMixin;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.state.ValueComponentState;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.autohud.render.ComponentRenderer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;

public class ColdSweatCompat
implements AutoHudApi {
    public static Component BODY_TEMP_GAUGE = Component.builder("cold_sweat", "body_temp").inMainHud().config(ConfigHandler.DummyBooleanComponent).state(player -> new ValueComponentState<Double>(BODY_TEMP_GAUGE, OverlaysMixin::getBODY_TEMP, true)).build();
    public static Component WORLD_TEMP_GAUGE = Component.builder("cold_sweat", "world_temp").inMainHud().config(ConfigHandler.DummyBooleanComponent).state(player -> new TemperatureState(WORLD_TEMP_GAUGE)).build();
    public static Component VAGUE_TEMP_GAUGE = Component.builder("cold_sweat", "vague_temp").inMainHud().config(ConfigHandler.DummyBooleanComponent).state(player -> new TemperatureState(VAGUE_TEMP_GAUGE)).build();
    public static ComponentRenderer BODY_TEMP_RENDERER = ComponentRenderer.of(BODY_TEMP_GAUGE);
    public static ComponentRenderer WORLD_TEMP_RENDERER = ComponentRenderer.of(WORLD_TEMP_GAUGE);
    public static ComponentRenderer VAGUE_TEMP_RENDERER = ComponentRenderer.of(VAGUE_TEMP_GAUGE);

    @Override
    public String modId() {
        return "cold_sweat";
    }

    @Override
    public void tickState(LocalPlayer player) {
        EntityTempManager.getTemperatureCap((Entity)player).ifPresent(icap -> {
            if (icap instanceof PlayerTempCap) {
                PlayerTempCap cap = (PlayerTempCap)icap;
                TemperatureState.PLAYER_MAX_TEMP = cap.getTrait(Temperature.Trait.BURNING_POINT);
                TemperatureState.PLAYER_MIN_TEMP = cap.getTrait(Temperature.Trait.FREEZING_POINT);
            }
        });
        BODY_TEMP_GAUGE.synchronizeFrom(VAGUE_TEMP_GAUGE);
        VAGUE_TEMP_GAUGE.synchronizeFrom(BODY_TEMP_GAUGE);
    }

    @Override
    public void init() {
    }

    static class TemperatureState
    extends ValueComponentState<Integer> {
        static double PLAYER_MAX_TEMP;
        static double PLAYER_MIN_TEMP;

        public TemperatureState(Component component) {
            super(component, () -> {
                double temp = Temperature.convert((double)Overlays.WORLD_TEMP, (Temperature.Units)((Boolean)ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F), (Temperature.Units)Temperature.Units.MC, (boolean)true);
                return Overlays.getGaugeSeverity((double)temp, (double)PLAYER_MIN_TEMP, (double)PLAYER_MAX_TEMP);
            }, true);
        }

        @Override
        protected boolean doReveal(Integer newValue) {
            return super.doReveal(newValue) || newValue < -2 || newValue > 2;
        }
    }
}

