/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud;

import mod.crend.autohud.AutoHud;
import mod.crend.autohud.AutoHudCompat;
import mod.crend.autohud.AutoHudGui;
import mod.crend.autohud.ModKeyBindings;
import mod.crend.autohud.api.AutoHudApi;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.autohud.render.AutoHudRenderer;
import mod.crend.libbamboo.ConfigScreen;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="autohud")
public class AutoHudMod {
    public AutoHudMod() {
        AutoHud.loadConfig();
    }

    @EventBusSubscriber(modid="autohud", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
            AutoHud.init();
            NeoForge.EVENT_BUS.register((Object)new AutoHudGui());
            ConfigScreen.register(() -> ConfigHandler.CONFIG_STORE);
            NeoForge.EVENT_BUS.addListener(ModBus::onClientTick);
            AutoHudCompat.registerCompatibilityProviders();
        }

        @SubscribeEvent
        static void onInterModProcess(InterModProcessEvent event) {
            InterModComms.getMessages((String)"autohud", "register_api"::equals).map(msg -> (AutoHudApi)msg.messageSupplier().get()).forEach(AutoHud::addApi);
        }

        @SubscribeEvent
        static void onKeyMappingsRegister(RegisterKeyMappingsEvent event) {
            ModKeyBindings.ALL.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        }

        @SubscribeEvent
        static void onRegisterOverlaysEvent(RegisterGuiLayersEvent event) {
            event.registerAboveAll(AutoHud.CHAT_INDICATOR, AutoHudRenderer::renderChatMessageIndicator);
        }

        static void onClientTick(ClientTickEvent.Post event) {
            ModKeyBindings.clientTick(Minecraft.getInstance());
        }
    }

    @EventBusSubscriber(modid="autohud", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class GameBus {
        @SubscribeEvent
        static void onPreRenderGuiEvent(RenderGuiEvent.Pre event) {
            AutoHudRenderer.startRender(event.getGuiGraphics(), event.getPartialTick());
        }

        @SubscribeEvent
        static void onPostRenderGuiEvent(RenderGuiEvent.Post event) {
            AutoHudRenderer.endRender();
        }

        @SubscribeEvent
        static void onChatMessageReceived(ClientChatReceivedEvent event) {
            if (Components.Chat.config.active() && Components.ChatIndicator.config.active() && Components.Chat.isHidden()) {
                Components.ChatIndicator.reveal();
            }
        }
    }
}

