/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.render.ComponentRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class AutoHudGui {
    public static final Map<ResourceLocation, ComponentRenderer> COMPONENT_RENDERERS = new HashMap<ResourceLocation, ComponentRenderer>();

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void preHudComponent(RenderGuiLayerEvent.Pre event) {
        Optional.ofNullable(COMPONENT_RENDERERS.get(event.getName())).ifPresent(wrapper -> {
            if (wrapper.isActive() && !wrapper.doRender()) {
                event.setCanceled(true);
            }
            wrapper.beginRender(event.getGuiGraphics());
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void cancelHudComponent(RenderGuiLayerEvent.Pre event) {
        if (event.isCanceled()) {
            Optional.ofNullable(COMPONENT_RENDERERS.get(event.getName())).ifPresent(wrapper -> wrapper.endRender(event.getGuiGraphics()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void postHudComponent(RenderGuiLayerEvent.Post event) {
        Optional.ofNullable(COMPONENT_RENDERERS.get(event.getName())).ifPresent(wrapper -> wrapper.endRender(event.getGuiGraphics()));
    }

    @SubscribeEvent
    public void preChat(CustomizeGuiOverlayEvent.Chat event) {
        if (Components.Chat.config.active()) {
            ComponentRenderer.CHAT.beginFade(event.getGuiGraphics());
        }
    }

    static {
        COMPONENT_RENDERERS.put(VanillaGuiLayers.PLAYER_HEALTH, ComponentRenderer.HEALTH);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.ARMOR_LEVEL, ComponentRenderer.ARMOR);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.FOOD_LEVEL, ComponentRenderer.HUNGER);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.AIR_LEVEL, ComponentRenderer.AIR);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.VEHICLE_HEALTH, ComponentRenderer.MOUNT_HEALTH);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.JUMP_METER, ComponentRenderer.MOUNT_JUMP_BAR);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.EXPERIENCE_BAR, ComponentRenderer.EXPERIENCE_BAR);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.EXPERIENCE_LEVEL, ComponentRenderer.EXPERIENCE_LEVEL);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.SCOREBOARD_SIDEBAR, ComponentRenderer.SCOREBOARD);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.HOTBAR, ComponentRenderer.HOTBAR);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.SELECTED_ITEM_NAME, ComponentRenderer.TOOLTIP);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.CHAT, ComponentRenderer.CHAT);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.TITLE, ComponentRenderer.ACTION_BAR);
        COMPONENT_RENDERERS.put(VanillaGuiLayers.BOSS_OVERLAY, ComponentRenderer.BOSS_BAR);
    }
}

