/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.autohud;

import java.util.ArrayList;
import java.util.List;
import mod.crend.autohud.api.AutoHudApi;
import mod.crend.autohud.component.EventHandler;
import mod.crend.autohud.component.Hud;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.libbamboo.PlatformUtils;
import mod.crend.libbamboo.VersionUtils;
import mod.crend.libbamboo.event.GameEvent;
import net.minecraft.resources.ResourceLocation;

public class AutoHud {
    public static final String MOD_ID = "autohud";
    public static final ResourceLocation CHAT_INDICATOR = VersionUtils.getIdentifier((String)"autohud", (String)"chat_indicator");
    public static final String REGISTER_API = "register_api";
    public static ConfigHandler config;
    public static final List<AutoHudApi> apis;
    public static boolean targetHotbar;
    public static boolean targetExperienceBar;
    public static boolean targetStatusBars;
    public static boolean targetScoreboard;
    public static boolean targetStatusEffects;
    public static boolean targetCrosshair;
    public static boolean targetChat;

    public static void loadConfig() {
        config = new ConfigHandler();
    }

    public static void init() {
        if (config.dynamicOnLoad()) {
            Hud.enableDynamic();
        }
        GameEvent.WORLD_LOAD.register(Hud::registerState);
        GameEvent.WORLD_TICK.register(Hud::tickState);
        GameEvent.WORLD_UNLOAD.register(Hud::unregisterState);
        GameEvent.PLAYER_RESPAWN.register(Hud::registerState);
        EventHandler.registerEvents();
    }

    public static void addApi(AutoHudApi api) {
        if (PlatformUtils.isModLoaded((String)api.modId())) {
            apis.add(api);
            api.init();
        }
    }

    static {
        apis = new ArrayList<AutoHudApi>();
        targetHotbar = true;
        targetExperienceBar = true;
        targetStatusBars = true;
        targetScoreboard = true;
        targetStatusEffects = true;
        targetCrosshair = true;
        targetChat = true;
    }
}

