/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.register;

import dev.lopyluna.gnkinetics.Gears;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class GearsTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return GearsTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static <T> TagKey<T> modTag(Registry<T> registry, String path) {
        return GearsTags.optionalTag(registry, Gears.loc(path));
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return GearsTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return GearsTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return GearsTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> modFluidTag(String path) {
        return GearsTags.modTag(BuiltInRegistries.FLUID, path);
    }

    public static TagKey<Block> modBlockTag(String path) {
        return GearsTags.modTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> modItemTag(String path) {
        return GearsTags.modTag(BuiltInRegistries.ITEM, path);
    }

    public static void init() {
        FluidTags.init();
        BlockTags.init();
        ItemTags.init();
    }

    public static final class FluidTags
    extends Enum<FluidTags> {
        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ FluidTags[] $VALUES;

        public static FluidTags[] values() {
            return (FluidTags[])$VALUES.clone();
        }

        public static FluidTags valueOf(String name) {
            return Enum.valueOf(FluidTags.class, name);
        }

        private FluidTags() {
            this(NameSpace.MOD);
        }

        private FluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private FluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private FluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private FluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? GearsTags.optionalTag(BuiltInRegistries.FLUID, id) : net.minecraft.tags.FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean is(Fluid fluid) {
            return fluid.builtInRegistryHolder().is(this.tag);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean is(ItemStack stack) {
            if (stack == null) return false;
            Item item = stack.getItem();
            if (!(item instanceof BucketItem)) return false;
            BucketItem bucket = (BucketItem)item;
            if (!this.is(bucket.content)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean is(ItemLike item) {
            if (!(item instanceof BucketItem)) return false;
            BucketItem bucket = (BucketItem)item;
            if (!this.is(bucket.content)) return false;
            return true;
        }

        public boolean is(FluidState state) {
            return state.is(this.tag);
        }

        public boolean is(TagKey<Fluid> tag) {
            return tag == this.tag;
        }

        private static void init() {
        }

        private static /* synthetic */ FluidTags[] $values() {
            return new FluidTags[0];
        }

        static {
            $VALUES = FluidTags.$values();
        }
    }

    public static final class BlockTags
    extends Enum<BlockTags> {
        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ BlockTags[] $VALUES;

        public static BlockTags[] values() {
            return (BlockTags[])$VALUES.clone();
        }

        public static BlockTags valueOf(String name) {
            return Enum.valueOf(BlockTags.class, name);
        }

        private BlockTags() {
            this(NameSpace.MOD);
        }

        private BlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private BlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? GearsTags.optionalTag(BuiltInRegistries.BLOCK, id) : net.minecraft.tags.BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean is(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean is(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.is((blockItem = (BlockItem)item).getBlock());
        }

        public boolean is(ItemLike item) {
            BlockItem blockItem;
            return item instanceof BlockItem && this.is((blockItem = (BlockItem)item).getBlock());
        }

        public boolean is(BlockState state) {
            return state.is(this.tag);
        }

        public boolean is(TagKey<Block> tag) {
            return tag == this.tag;
        }

        private static void init() {
        }

        private static /* synthetic */ BlockTags[] $values() {
            return new BlockTags[0];
        }

        static {
            $VALUES = BlockTags.$values();
        }
    }

    public static final class ItemTags
    extends Enum<ItemTags> {
        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ ItemTags[] $VALUES;

        public static ItemTags[] values() {
            return (ItemTags[])$VALUES.clone();
        }

        public static ItemTags valueOf(String name) {
            return Enum.valueOf(ItemTags.class, name);
        }

        private ItemTags() {
            this(NameSpace.MOD);
        }

        private ItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private ItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private ItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private ItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? GearsTags.optionalTag(BuiltInRegistries.ITEM, id) : net.minecraft.tags.ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ ItemTags[] $values() {
            return new ItemTags[0];
        }

        static {
            $VALUES = ItemTags.$values();
        }
    }

    public static enum NameSpace {
        MOD("gnkinetics", false, true),
        COMMON("c"),
        CREATE("create");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

