/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.register;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllSoundEvents;
import dev.lopyluna.gnkinetics.Gears;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class GearsSoundEvents {
    public static final Map<ResourceLocation, AllSoundEvents.SoundEntry> ALL = new HashMap<ResourceLocation, AllSoundEvents.SoundEntry>();

    private static GearsSoundEntryBuilder create(String name) {
        return GearsSoundEvents.create(Gears.loc(name));
    }

    public static GearsSoundEntryBuilder create(ResourceLocation id) {
        return new GearsSoundEntryBuilder(id);
    }

    public static void prepare() {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register(RegisterEvent event) {
        event.register(Registries.SOUND_EVENT, helper -> ALL.values().forEach(entry -> entry.register(helper)));
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            consumer.accept(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    public static class GearsSoundEntryBuilder
    extends AllSoundEvents.SoundEntryBuilder {
        public GearsSoundEntryBuilder(ResourceLocation id) {
            super(id);
        }

        public GearsSoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public GearsSoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public GearsSoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public GearsSoundEntryBuilder category(SoundSource category) {
            this.category = category;
            return this;
        }

        public GearsSoundEntryBuilder addVariant(String name) {
            return this.addVariant(Gears.loc(name));
        }

        public GearsSoundEntryBuilder addVariant(ResourceLocation id) {
            this.variants.add(id);
            return this;
        }

        public GearsSoundEntryBuilder playExisting(Supplier<SoundEvent> event, float volume, float pitch) {
            this.wrappedEvents.add(new AllSoundEvents.ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public GearsSoundEntryBuilder playExisting(SoundEvent event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public GearsSoundEntryBuilder playExisting(SoundEvent event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public GearsSoundEntryBuilder playExisting(Holder<SoundEvent> event) {
            return this.playExisting(() -> event.value(), 1.0f, 1.0f);
        }

        public AllSoundEvents.SoundEntry build() {
            AllSoundEvents.SoundEntry entry = super.build();
            ALL.put(entry.getId(), entry);
            AllSoundEvents.ALL.remove(entry.getId());
            return entry;
        }
    }

    public static class SoundEntryProvider
    implements DataProvider {
        private final PackOutput output;

        public SoundEntryProvider(DataGenerator generator) {
            this.output = generator.getPackOutput();
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            return this.generate(this.output.getOutputFolder(), cache);
        }

        @NotNull
        public String getName() {
            return "Gears's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/gnkinetics");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((AllSoundEvents.SoundEntry)entry.getValue()).write(json));
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }
}

