/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.register;

import com.simibubi.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.INewAxisConnection;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.tiny_cog.TinyCogBlock;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GearsRotationPropagation {
    public static Float propagateRotationTo(KineticBlockEntity target, BlockState targetState, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        boolean isLargeFrom = ICogWheel.isLargeCog((BlockState)stateFrom);
        boolean isLargeTo = ICogWheel.isLargeCog((BlockState)stateTo);
        if (GearsRotationPropagation.isSamePlaneAndAxis(stateFrom, stateTo, diff)) {
            Direction.Axis axis = GearsRotationPropagation.getAxis(stateFrom);
            Direction[] directionArray = Iterate.directions;
            int n = directionArray.length;
            for (int i = 0; i < n; ++i) {
                Direction dir = directionArray[i];
                if (dir.getAxis() == axis) continue;
                int dif = diff.get(dir.getAxis());
                if (Mth.abs((int)dif) == 2 && ICogWheel.isSmallCog((BlockState)stateFrom) && stateTo.is(GearsBlocks.RING_GEAR)) {
                    return Float.valueOf(-0.25f);
                }
                if (Mth.abs((int)dif) == 2 && ICogWheel.isSmallCog((BlockState)stateTo) && stateFrom.is(GearsBlocks.RING_GEAR)) {
                    return Float.valueOf(-4.0f);
                }
                boolean f = dir.getNormal().equals((Object)diff);
                if (f && isLargeFrom && TinyCogBlock.isTinyCog(stateTo)) {
                    return Float.valueOf(-4.0f);
                }
                if (!f || !isLargeTo || !TinyCogBlock.isTinyCog(stateFrom)) continue;
                return Float.valueOf(-0.25f);
            }
        }
        for (Direction dir : Iterate.directions) {
            boolean flag;
            if (!dir.getNormal().equals((Object)diff)) continue;
            Direction.Axis axis = dir.getAxis();
            Direction.Axis axisFrom = GearsRotationPropagation.getAxis(stateFrom);
            Direction.Axis axisTo = GearsRotationPropagation.getAxis(stateTo);
            if (axisFrom == axis || axisTo == axis) break;
            boolean bl = flag = axisFrom == axisTo;
            if (isLargeFrom && stateTo.is(GearsBlocks.WORM_GEAR)) {
                return Float.valueOf(flag ? -4.0f : GantryCarriageBlockEntity.getGantryPinionModifier((Direction)((Direction)stateTo.getValue((Property)BlockStateProperties.FACING)), (Direction)dir) * 4.0f);
            }
            if (!isLargeTo || !stateFrom.is(GearsBlocks.WORM_GEAR)) continue;
            return Float.valueOf(flag ? -0.25f : GantryCarriageBlockEntity.getGantryPinionModifier((Direction)((Direction)stateFrom.getValue((Property)BlockStateProperties.FACING)), (Direction)dir.getOpposite()) / 4.0f);
        }
        return null;
    }

    public static void addPropagationLocations(KineticBlockEntity be, Level level, IRotate block, BlockState state, BlockPos pos, Direction.Axis axis, List<BlockPos> neighbours) {
        if (axis != null && ICogWheel.isSmallCog((BlockState)state)) {
            for (Direction dir : Iterate.directions) {
                if (dir.getAxis() == axis) continue;
                neighbours.add(pos.relative(dir, 2));
            }
        }
        if (!INewAxisConnection.isValidNewShaft(state)) {
            for (Direction facing : Iterate.directions) {
                INewAxisConnection newCon;
                BlockPos offset = pos.relative(facing);
                BlockState offState = level.getBlockState(offset);
                while (INewAxisConnection.isValidNewShaft(level.getBlockState(offset))) {
                    offset = offset.relative(facing);
                }
                Block block2 = offState.getBlock();
                if (!(block2 instanceof INewAxisConnection) || !(newCon = (INewAxisConnection)block2).hasNewShaft(offState) || !newCon.hasNewShaftTowards((LevelReader)level, offset, offState, facing.getOpposite()) || !block.hasShaftTowards((LevelReader)level, pos, state, facing) || !level.isLoaded(offset)) continue;
                neighbours.add(offset);
            }
        }
    }

    public static void removePropagationLocations(KineticBlockEntity be, Level level, IRotate block, BlockState state, BlockPos pos, Direction.Axis axis, List<BlockPos> neighbours) {
        if (!INewAxisConnection.isValidNewShaft(state)) {
            for (Direction facing : Iterate.directions) {
                INewAxisConnection newCon;
                BlockPos offset = pos.relative(facing);
                BlockState offState = level.getBlockState(offset);
                Block block2 = offState.getBlock();
                if (!(block2 instanceof INewAxisConnection) || !(newCon = (INewAxisConnection)block2).hasNewShaft(offState) || !newCon.hasNewShaftTowards((LevelReader)level, offset, offState, facing.getOpposite()) || !block.hasShaftTowards((LevelReader)level, pos, state, facing) || !level.isLoaded(offset)) continue;
                neighbours.add(offset);
            }
        }
    }

    public static int isSamePlaneAndAxisOrDir(BlockState stateFrom, BlockState stateTo, BlockPos diff) {
        int i = 1;
        Direction.Axis axisF = GearsRotationPropagation.getAxis(stateFrom);
        if (axisF == null) {
            return 0;
        }
        Direction.Axis axisT = GearsRotationPropagation.getAxis(stateTo);
        if (axisT == null) {
            return 0;
        }
        boolean flag = false;
        if (diff.getX() == 1 || diff.getX() == -1) {
            flag = axisT != Direction.Axis.X;
            i = diff.getX();
        } else if (diff.getY() == 1 || diff.getY() == -1) {
            flag = axisT != Direction.Axis.Y;
            i = diff.getY();
        } else if (diff.getZ() == 1 || diff.getZ() == -1) {
            flag = axisT != Direction.Axis.Z;
            i = diff.getZ();
        }
        return (axisF == axisT || flag) && diff.get(axisF) == 0 ? i : 0;
    }

    public static void register() {
    }

    public static boolean isSameAxis(BlockState stateFrom, BlockState stateTo) {
        Direction.Axis axisF = GearsRotationPropagation.getAxis(stateFrom);
        if (axisF == null) {
            return false;
        }
        Direction.Axis axisT = GearsRotationPropagation.getAxis(stateTo);
        if (axisT == null) {
            return false;
        }
        return axisF == axisT;
    }

    public static boolean isSamePlaneAndAxis(BlockState stateFrom, BlockState stateTo, BlockPos posFrom, BlockPos posTo) {
        Direction.Axis axisF = GearsRotationPropagation.getAxis(stateFrom);
        if (axisF == null) {
            return false;
        }
        Direction.Axis axisT = GearsRotationPropagation.getAxis(stateTo);
        if (axisT == null) {
            return false;
        }
        return axisF == axisT && posFrom.get(axisF) == posTo.get(axisT);
    }

    public static boolean isSamePlaneAndAxis(BlockState stateFrom, BlockState stateTo, BlockPos diff) {
        Direction.Axis axisF = GearsRotationPropagation.getAxis(stateFrom);
        if (axisF == null) {
            return false;
        }
        Direction.Axis axisT = GearsRotationPropagation.getAxis(stateTo);
        if (axisT == null) {
            return false;
        }
        return axisF == axisT && diff.get(axisF) == 0;
    }

    public static Direction.Axis getAxis(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof ICogWheel) {
            ICogWheel cog = (ICogWheel)block;
            return cog.getRotationAxis(state);
        }
        block = state.getBlock();
        if (block instanceof IRotate) {
            IRotate rot = (IRotate)block;
            return rot.getRotationAxis(state);
        }
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            return (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            return (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            return ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getAxis();
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING_HOPPER)) {
            return ((Direction)state.getValue((Property)BlockStateProperties.FACING_HOPPER)).getAxis();
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis();
        }
        if (state.hasProperty((Property)BlockStateProperties.VERTICAL_DIRECTION)) {
            return ((Direction)state.getValue((Property)BlockStateProperties.VERTICAL_DIRECTION)).getAxis();
        }
        return null;
    }
}

