/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.events;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.gnkinetics.content.client.DebugOutliner;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="gnkinetics", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class WorldClientEvents {
    private static final Minecraft mc = Minecraft.getInstance();

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        if (mc.getConnection() == null || WorldClientEvents.mc.player == null || WorldClientEvents.mc.level == null) {
            return;
        }
        DebugOutliner.getDebugInstance().tickOutlines();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (mc.getConnection() == null || WorldClientEvents.mc.player == null || WorldClientEvents.mc.level == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        Vec3 cameraPos = event.getCamera().getPosition();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        ms.pushPose();
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        DebugOutliner.getDebugInstance().renderOutlines(ms, (SuperRenderTypeBuffer)buffer, cameraPos, partialTicks);
        buffer.draw();
        ms.pushPose();
    }
}

