/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.events;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.utility.BlockHelper;
import dev.lopyluna.gnkinetics.Gears;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs.CustomCogWheelBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear.RingGearBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.tiny_cog.TinyCogBlock;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="gnkinetics", bus=EventBusSubscriber.Bus.GAME)
public class ServerEvents {
    private static final int ringGearLargeCogHelperId = PlacementHelpers.register((IPlacementHelper)new RingGearLargeCogHelper());
    private static final int ringGearSmallCogHelperId = PlacementHelpers.register((IPlacementHelper)new RingGearSmallCogHelper());
    private static final int tinyCogLargeCogHelperId = PlacementHelpers.register((IPlacementHelper)new TinyCogLargeCogHelper());

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        Gears.LOGGER.info("GnKinetics SERVER SETUP");
    }

    @SubscribeEvent
    public static void useItemOn(UseItemOnBlockEvent event) {
        Item newState;
        CustomCogWheelBlock block;
        BlockItem item;
        Item item2;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        InteractionHand hand = event.getHand();
        UseOnContext context = event.getUseOnContext();
        BlockHitResult hitResult = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos, context.isInside());
        UseItemOnBlockEvent.UsePhase phase = event.getUsePhase();
        boolean shift = player.isShiftKeyDown();
        if (phase == UseItemOnBlockEvent.UsePhase.ITEM_BEFORE_BLOCK && !shift && (item2 = stack.getItem()) instanceof BlockItem && (item2 = (item = (BlockItem)item2).getBlock()) instanceof CustomCogWheelBlock && (block = (CustomCogWheelBlock)item2).isHollowed() && state.is((Holder)AllBlocks.SHAFT)) {
            if (!CogWheelBlock.isValidCogwheelPosition((boolean)block.isLargeCog(), (LevelReader)level, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS)))) {
                return;
            }
            newState = (BlockState)BlockHelper.copyProperties((BlockState)state, (BlockState)block.defaultBlockState()).setValue((Property)CustomCogWheelBlock.HAS_SHAFT, (Comparable)Boolean.valueOf(true));
            SoundType sound = newState.getSoundType((LevelReader)level, pos, (Entity)player);
            level.playSound(player, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)level, (BlockPos)pos));
            level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            if (!player.isCreative()) {
                stack.shrink(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)AllBlocks.SHAFT.asStack());
            }
            event.cancelWithResult(ItemInteractionResult.SUCCESS);
        }
        if (phase == UseItemOnBlockEvent.UsePhase.BLOCK) {
            IPlacementHelper ringGear;
            if (!shift && (newState = stack.getItem()) instanceof BlockItem && (newState = (item = (BlockItem)newState).getBlock()) instanceof CustomCogWheelBlock && (block = (CustomCogWheelBlock)newState).isHollowed() && state.is((Holder)AllBlocks.SHAFT)) {
                if (!CogWheelBlock.isValidCogwheelPosition((boolean)block.isLargeCog(), (LevelReader)level, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS)))) {
                    return;
                }
                event.cancelWithResult(ItemInteractionResult.SUCCESS);
                return;
            }
            IPlacementHelper placer = null;
            if (ICogWheel.isLargeCog((BlockState)state)) {
                ringGear = PlacementHelpers.get((int)ringGearLargeCogHelperId);
                IPlacementHelper tinyCog = PlacementHelpers.get((int)tinyCogLargeCogHelperId);
                if (ringGear.matchesItem(stack)) {
                    placer = ringGear;
                }
                if (tinyCog.matchesItem(stack)) {
                    placer = tinyCog;
                }
            }
            if (ICogWheel.isSmallCog((BlockState)state) && (ringGear = PlacementHelpers.get((int)ringGearSmallCogHelperId)).matchesItem(stack)) {
                placer = ringGear;
            }
            if (placer != null) {
                event.cancelWithResult(placer.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult));
            }
        }
    }

    @MethodsReturnNonnullByDefault
    private static class RingGearLargeCogHelper
    implements IPlacementHelper {
        private RingGearLargeCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.is(GearsBlocks.RING_GEAR.asItem());
        }

        public Predicate<BlockState> getStatePredicate() {
            return ICogWheel::isLargeCog;
        }

        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult ray) {
            Block block = state.getBlock();
            if (block instanceof IRotate) {
                IRotate rot = (IRotate)block;
                Direction.Axis axis = rot.getRotationAxis(state);
                Direction side = (Direction)IPlacementHelper.orderedByDistanceOnlyAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis).getFirst();
                for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis)) {
                    BlockPos newPos = pos.relative(dir).relative(side);
                    if (!CogWheelBlock.isValidCogwheelPosition((boolean)true, (LevelReader)level, (BlockPos)newPos, (Direction.Axis)dir.getAxis()) || !RingGearBlock.canPlace(dir.getAxis(), newPos, level) || !level.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)dir.getAxis()));
                }
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    private static class RingGearSmallCogHelper
    implements IPlacementHelper {
        private RingGearSmallCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.is(GearsBlocks.RING_GEAR.asItem());
        }

        public Predicate<BlockState> getStatePredicate() {
            return ICogWheel::isSmallCog;
        }

        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult ray) {
            Block block = state.getBlock();
            if (block instanceof IRotate) {
                IRotate rot = (IRotate)block;
                Direction.Axis axis = rot.getRotationAxis(state);
                for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis)) {
                    BlockPos newPos = pos.relative(dir, 2);
                    if (!CogWheelBlock.isValidCogwheelPosition((boolean)false, (LevelReader)level, (BlockPos)newPos, (Direction.Axis)axis) || !RingGearBlock.canPlace(axis, newPos, level) || !level.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
                }
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    private static class TinyCogLargeCogHelper
    implements IPlacementHelper {
        private TinyCogLargeCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> TinyCogBlock.isTinyCog(i) || i.is(GearsBlocks.WORM_GEAR.asItem());
        }

        public Predicate<BlockState> getStatePredicate() {
            return ICogWheel::isLargeCog;
        }

        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult ray) {
            Block block = state.getBlock();
            if (block instanceof IRotate) {
                IRotate rot = (IRotate)block;
                Direction.Axis axis = rot.getRotationAxis(state);
                for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis)) {
                    BlockPos newPos = pos.relative(dir);
                    if (!level.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> s.hasProperty((Property)RotatedPillarKineticBlock.AXIS) ? (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis) : (s.hasProperty((Property)BlockStateProperties.FACING) ? (BlockState)s.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)(player.isShiftKeyDown() ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE))) : s));
                }
            }
            return PlacementOffset.fail();
        }
    }
}

