/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers.ChainableCogwheelConnectionHandler;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers.ChainableCogwheelInteractionHandler;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.chainned_cog.handlers.ChainableCogwheelRidingHandler;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="gnkinetics", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onTickPre(ClientTickEvent.Pre event) {
        ClientEvents.onTick(true);
    }

    @SubscribeEvent
    public static void onTickPost(ClientTickEvent.Post event) {
        ClientEvents.onTick(false);
    }

    public static void onTick(boolean isPreEvent) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (isPreEvent) {
            return;
        }
        ChainableCogwheelInteractionHandler.clientTick();
        ChainableCogwheelRidingHandler.clientTick();
        ChainableCogwheelConnectionHandler.clientTick();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        ms.pushPose();
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        ChainableCogwheelInteractionHandler.drawCustomBlockSelection(ms, (MultiBufferSource)buffer, camera);
        buffer.draw();
        RenderSystem.enableCull();
        ms.popPose();
    }

    protected static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }
}

