/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.utils;

import com.simibubi.create.foundation.utility.BlockHelper;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.cog_crank.CogCrankBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.creative_gear_motor.CreativeGearMotorBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs.CustomCogWheelBlock;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class GearsRemapper {
    private static final List<String> TARGET_MOD_IDS = new ArrayList<String>();
    private static final Map<Item, Item> ITEM_REMAP = new HashMap<Item, Item>();
    private static final Map<Block, Block> BLOCK_REMAP = new HashMap<Block, Block>();

    public static Item remapItem(Item item) {
        Item newItem = ITEM_REMAP.get(item);
        return newItem != null ? newItem : item;
    }

    public static ItemStack remapItemStack(ItemStack stack) {
        Item item = ITEM_REMAP.get(stack.getItem());
        return item != null ? stack.transmuteCopy((ItemLike)item) : stack;
    }

    public static Block remapBlock(Block block) {
        Block newBlock = BLOCK_REMAP.get(block);
        return newBlock != null ? newBlock : block;
    }

    public static BlockState remapBlockState(BlockState state) {
        Block block = BLOCK_REMAP.get(state.getBlock());
        return block != null ? BlockHelper.copyProperties((BlockState)state, (BlockState)block.defaultBlockState()) : state;
    }

    public static void register() {
        TARGET_MOD_IDS.add("dndecor");
        TARGET_MOD_IDS.add("dndesires");
        GearsRemapper.buildBlockRemap();
        GearsRemapper.buildItemRemap();
    }

    public static void buildBlockRemap() {
        for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
            Block remapped;
            Block block = (Block)entry.getValue();
            ResourceLocation blockID = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!TARGET_MOD_IDS.contains(blockID.getNamespace()) || (remapped = GearsRemapper.remapBlocks(blockID)) == null) continue;
            BLOCK_REMAP.put(block, remapped);
        }
    }

    public static void buildItemRemap() {
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            Item remapped;
            Item item = (Item)entry.getValue();
            ResourceLocation itemID = BuiltInRegistries.ITEM.getKey((Object)item);
            if (!TARGET_MOD_IDS.contains(itemID.getNamespace()) || (remapped = GearsRemapper.remapItems(itemID)) == null) continue;
            ITEM_REMAP.put(item, remapped);
        }
    }

    private static Block remapBlocks(ResourceLocation blockLoc) {
        return switch (blockLoc.getPath()) {
            case "industrial_cogwheel" -> (CustomCogWheelBlock)GearsBlocks.INDUSTRIAL_GEAR.get();
            case "large_industrial_cogwheel" -> (CustomCogWheelBlock)GearsBlocks.LARGE_INDUSTRIAL_GEAR.get();
            case "cog_crank" -> (CogCrankBlock)((Object)GearsBlocks.COG_CRANK.get());
            case "large_cog_crank" -> (CogCrankBlock)((Object)GearsBlocks.LARGE_COG_CRANK.get());
            case "creative_gear_motor" -> (CreativeGearMotorBlock)((Object)GearsBlocks.CREATIVE_GEAR_MOTOR.get());
            default -> null;
        };
    }

    private static Item remapItems(ResourceLocation itemLoc) {
        return switch (itemLoc.getPath()) {
            case "industrial_cogwheel" -> GearsBlocks.INDUSTRIAL_GEAR.asItem();
            case "large_industrial_cogwheel" -> GearsBlocks.LARGE_INDUSTRIAL_GEAR.asItem();
            case "cog_crank" -> GearsBlocks.COG_CRANK.asItem();
            case "large_cog_crank" -> GearsBlocks.LARGE_COG_CRANK.asItem();
            case "creative_gear_motor" -> GearsBlocks.CREATIVE_GEAR_MOTOR.asItem();
            default -> null;
        };
    }
}

