/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.propagators;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.gnkinetics.content.propagators.RotationPropagation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RotationPropagationRegistry {
    private static final Map<NonNullSupplier<Block>, RotationPropagation> handlers = new HashMap<NonNullSupplier<Block>, RotationPropagation>();
    private static final List<RotationPropagation> singleHandlers = new ArrayList<RotationPropagation>();

    public static void register(NonNullSupplier<Block> block, RotationPropagation handler) {
        handlers.put(block, handler);
    }

    public static RotationPropagation register(RotationPropagation handler) {
        singleHandlers.add(handler);
        return handler;
    }

    public static RotationPropagation get(NonNullSupplier<Block> block) {
        return !handlers.isEmpty() ? handlers.get(block) : null;
    }

    public static RotationPropagation get(Block block) {
        return RotationPropagationRegistry.get((NonNullSupplier<Block>)((NonNullSupplier)() -> block));
    }

    public static RotationPropagation get(BlockState state) {
        return RotationPropagationRegistry.get((NonNullSupplier<Block>)((NonNullSupplier)() -> ((BlockState)state).getBlock()));
    }

    public static RotationPropagation get(Level level, BlockPos pos) {
        return RotationPropagationRegistry.get(level.getBlockState(pos));
    }

    public static RotationPropagation get(KineticBlockEntity be) {
        return be != null ? RotationPropagationRegistry.get(be.getBlockState()) : null;
    }

    public static List<RotationPropagation> getEntries() {
        return singleHandlers;
    }
}

