/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.datagen.recipes;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import dev.lopyluna.gnkinetics.Gears;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import dev.lopyluna.gnkinetics.register.GearsTags;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;

public class VanillaRecipeGen
extends BaseRecipeProvider {
    final List<BaseRecipeProvider.GeneratedRecipe> all = new ArrayList<BaseRecipeProvider.GeneratedRecipe>();
    BaseRecipeProvider.GeneratedRecipe MAGNET_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.MAGNET_GEAR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.TRANSMITTER).get())).viaShapeless(b -> b.requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GearsBlocks.INDUSTRIAL_GEAR.get(), (ItemLike)GearsBlocks.SHAFTLESS_INDUSTRIAL_GEAR.get()})).requires((ItemLike)AllItems.TRANSMITTER));
    BaseRecipeProvider.GeneratedRecipe LARGE_MAGNET_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.LARGE_MAGNET_GEAR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.TRANSMITTER).get())).viaShapeless(b -> b.requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GearsBlocks.LARGE_INDUSTRIAL_GEAR.get(), (ItemLike)GearsBlocks.LARGE_SHAFTLESS_INDUSTRIAL_GEAR.get()})).requires((ItemLike)AllItems.TRANSMITTER).requires((ItemLike)AllItems.TRANSMITTER));
    BaseRecipeProvider.GeneratedRecipe WORM_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.WORM_GEAR).returns(8).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.IRON_SHEET).get())).viaShaped(b -> b.define(Character.valueOf('i'), GearsTags.commonItemTag("plates/iron")).define(Character.valueOf('a'), (ItemLike)AllItems.ANDESITE_ALLOY).pattern("a").pattern("i").pattern("a"));
    BaseRecipeProvider.GeneratedRecipe RING_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.RING_GEAR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.BRASS_INGOT).get())).viaShaped(b -> b.define(Character.valueOf('b'), GearsTags.commonItemTag("ingots/brass")).define(Character.valueOf('g'), GearsBlocks.LARGE_HOLLOW_BRASS_GEAR).pattern("bbb").pattern("bgb").pattern("bbb"));
    BaseRecipeProvider.GeneratedRecipe CHAINABLE_COGWHEEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.CHAINABLE_COGWHEEL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.ANDESITE_CASING).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.LARGE_COGWHEEL.get()).requires((ItemLike)AllBlocks.ANDESITE_CASING).requires(GearsTags.commonItemTag("nuggets/iron")).requires(GearsTags.commonItemTag("nuggets/iron")));
    BaseRecipeProvider.GeneratedRecipe CHAINABLE_COGWHEEL_ZINC = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.CHAINABLE_COGWHEEL).withSuffix("_from_zinc").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.ANDESITE_CASING).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.LARGE_COGWHEEL.get()).requires((ItemLike)AllBlocks.ANDESITE_CASING).requires(GearsTags.commonItemTag("nuggets/zinc")).requires(GearsTags.commonItemTag("nuggets/zinc")));
    BaseRecipeProvider.GeneratedRecipe TINY_COGWHEEL = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.TINY_COG).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.ANDESITE_ALLOY).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires(ItemTags.WOODEN_SLABS));
    BaseRecipeProvider.GeneratedRecipe TINY_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.TINY_BRASS_COG).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.BRASS_INGOT).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires(GearsTags.commonItemTag("nuggets/brass")).requires(GearsTags.commonItemTag("nuggets/brass")).requires(GearsTags.commonItemTag("nuggets/brass")));
    BaseRecipeProvider.GeneratedRecipe GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.BRASS_GEAR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.BRASS_INGOT).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires(GearsTags.commonItemTag("ingots/brass")));
    BaseRecipeProvider.GeneratedRecipe LARGE_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.LARGE_BRASS_GEAR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.BRASS_INGOT).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires(GearsTags.commonItemTag("ingots/brass")).requires(GearsTags.commonItemTag("ingots/brass")));
    BaseRecipeProvider.GeneratedRecipe INDUSTRIAL_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.INDUSTRIAL_GEAR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.INDUSTRIAL_IRON_BLOCK).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires((ItemLike)AllBlocks.INDUSTRIAL_IRON_BLOCK.get()));
    BaseRecipeProvider.GeneratedRecipe INDUSTRIAL_LARGE_GEAR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.LARGE_INDUSTRIAL_GEAR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.INDUSTRIAL_IRON_BLOCK).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires((ItemLike)AllBlocks.INDUSTRIAL_IRON_BLOCK.get()).requires((ItemLike)AllBlocks.INDUSTRIAL_IRON_BLOCK.get()));
    BaseRecipeProvider.GeneratedRecipe COGSTONE = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.COG_STONE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.SHAFT).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires(GearsTags.commonItemTag("stones")));
    BaseRecipeProvider.GeneratedRecipe ANDESITE_COG = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)GearsBlocks.ANDESITE_COG).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((BlockEntry)AllBlocks.SHAFT).get())).viaShapeless(b -> b.requires((ItemLike)AllBlocks.SHAFT.get()).requires((ItemLike)AllItems.ANDESITE_ALLOY.get()));
    BaseRecipeProvider.GeneratedRecipe COGSTONE_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.COG_STONE, GearsBlocks.SHAFTLESS_COG_STONE));
    BaseRecipeProvider.GeneratedRecipe ANDESITE_COG_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.ANDESITE_COG, GearsBlocks.SHAFTLESS_ANDESITE_COG));
    BaseRecipeProvider.GeneratedRecipe INDUSTRIAL_GEAR_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.INDUSTRIAL_GEAR, GearsBlocks.SHAFTLESS_INDUSTRIAL_GEAR));
    BaseRecipeProvider.GeneratedRecipe INDUSTRIAL_LARGE_GEAR_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.LARGE_INDUSTRIAL_GEAR, GearsBlocks.LARGE_SHAFTLESS_INDUSTRIAL_GEAR));
    BaseRecipeProvider.GeneratedRecipe TINY_COGWHEEL_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.TINY_COG, GearsBlocks.SHAFTLESS_TINY_COG));
    BaseRecipeProvider.GeneratedRecipe COGWHEEL_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of((Object)AllBlocks.COGWHEEL, GearsBlocks.SHAFTLESS_COGWHEEL, GearsBlocks.HOLLOW_COGWHEEL));
    BaseRecipeProvider.GeneratedRecipe LARGE_COGWHEEL_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of((Object)AllBlocks.LARGE_COGWHEEL, GearsBlocks.LARGE_SHAFTLESS_COGWHEEL, GearsBlocks.LARGE_HOLLOW_COGWHEEL));
    BaseRecipeProvider.GeneratedRecipe TINY_BRASS_GEAR_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.TINY_BRASS_COG, GearsBlocks.SHAFTLESS_TINY_BRASS_COG));
    BaseRecipeProvider.GeneratedRecipe BRASS_GEAR_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.BRASS_GEAR, GearsBlocks.SHAFTLESS_BRASS_GEAR, GearsBlocks.HOLLOW_BRASS_GEAR));
    BaseRecipeProvider.GeneratedRecipe LARGE_BRASS_GEAR_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>>)ImmutableList.of(GearsBlocks.LARGE_BRASS_GEAR, GearsBlocks.LARGE_SHAFTLESS_BRASS_GEAR, GearsBlocks.LARGE_HOLLOW_BRASS_GEAR));
    String currentFolder = "";

    Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new Marker();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    BaseRecipeProvider.GeneratedRecipe createSpecial(Function<CraftingBookCategory, Recipe<?>> builder, String recipeType, String path) {
        return this.register(consumer -> SpecialRecipeBuilder.special((Function)builder).save(consumer, Gears.loc(recipeType + "/" + this.currentFolder + "/" + path).toString()));
    }

    BaseRecipeProvider.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>> cycle) {
        BaseRecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShapeless(b -> b.requires((ItemLike)currentEntry.get()));
        }
        return result;
    }

    BaseRecipeProvider.GeneratedRecipe clearData(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> item) {
        return this.create(item).withSuffix("_clear").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item.get())).viaShapeless(b -> b.requires((ItemLike)item.get()));
    }

    public void buildRecipes(RecipeOutput output) {
        this.all.forEach(c -> c.register(output));
        Gears.LOGGER.info("{} registered {} recipe{}", new Object[]{this.getName(), this.all.size(), this.all.size() == 1 ? "" : "s"});
    }

    protected BaseRecipeProvider.GeneratedRecipe register(BaseRecipeProvider.GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    public VanillaRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "gnkinetics");
    }

    static class Marker {
        Marker() {
        }
    }

    class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        List<ICondition> recipeConditions;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return VanillaRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", VanillaRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation());
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return VanillaRecipeGen.this.register(recipeOutput -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", VanillaRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(recipeOutput, this.createLocation());
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return Gears.loc(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation createLocation() {
            if (this.path == null || this.path.isEmpty() || this.path.equals("null")) {
                return Gears.loc("crafting/" + this.getRegistryName().getPath() + this.suffix);
            }
            return Gears.loc("crafting/" + this.path + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem()) : this.compatDatagenOutput;
        }
    }
}

