/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.worm_gear;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.gantry.GantryShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.placement.PoleHelper;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.worm_gear.WormGearBE;
import dev.lopyluna.gnkinetics.register.GearsBETypes;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class WormGearBlock
extends DirectionalKineticBlock
implements IBE<WormGearBE> {
    public static final Property<GantryShaftBlock.Part> PART = EnumProperty.create((String)"part", GantryShaftBlock.Part.class);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    private static final int placementHelperLargeCogId = PlacementHelpers.register((IPlacementHelper)new PlacementHelperLargeCog());

    public WormGearBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PART, (Comparable)GantryShaftBlock.Part.SINGLE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{PART}));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        IPlacementHelper placementHelperLargeCog = PlacementHelpers.get((int)placementHelperLargeCogId);
        IPlacementHelper placer = null;
        if (placementHelper.matchesItem(stack)) {
            placer = placementHelper;
        }
        if (placementHelperLargeCog.matchesItem(stack)) {
            placer = placementHelperLargeCog;
        }
        if (placer == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return placer.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.EIGHT_VOXEL_POLE.get(((Direction)state.getValue((Property)FACING)).getAxis());
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbour, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction.Axis axis = facing.getAxis();
        if (direction.getAxis() != axis) {
            return state;
        }
        boolean connect = GearsBlocks.WORM_GEAR.has(neighbour) && neighbour.getValue((Property)FACING) == facing;
        GantryShaftBlock.Part part = (GantryShaftBlock.Part)state.getValue(PART);
        if (direction.getAxisDirection() == facing.getAxisDirection()) {
            if (connect) {
                switch (part) {
                    case END: {
                        part = GantryShaftBlock.Part.MIDDLE;
                        break;
                    }
                    case SINGLE: {
                        part = GantryShaftBlock.Part.START;
                    }
                }
            } else {
                switch (part) {
                    case MIDDLE: {
                        part = GantryShaftBlock.Part.END;
                        break;
                    }
                    case START: {
                        part = GantryShaftBlock.Part.SINGLE;
                    }
                }
            }
        } else if (connect) {
            switch (part) {
                case START: {
                    part = GantryShaftBlock.Part.MIDDLE;
                    break;
                }
                case SINGLE: {
                    part = GantryShaftBlock.Part.END;
                }
            }
        } else {
            switch (part) {
                case MIDDLE: {
                    part = GantryShaftBlock.Part.START;
                    break;
                }
                case END: {
                    part = GantryShaftBlock.Part.SINGLE;
                }
            }
        }
        return (BlockState)state.setValue(PART, (Comparable)part);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState clickedState;
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Direction face = context.getClickedFace();
        BlockState neighbour = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        BlockState blockState = clickedState = GearsBlocks.WORM_GEAR.has(neighbour) ? neighbour : level.getBlockState(pos.relative(face.getOpposite()));
        if (GearsBlocks.WORM_GEAR.has(clickedState) && ((Direction)clickedState.getValue((Property)FACING)).getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis()) {
            Direction facing = (Direction)clickedState.getValue((Property)FACING);
            state = (BlockState)state.setValue((Property)FACING, (Comparable)(context.getPlayer() == null || !context.getPlayer().isShiftKeyDown() ? facing : facing.getOpposite()));
        }
        return state;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (onWrenched.consumesAction()) {
            BlockPos pos = context.getClickedPos();
            Level level = context.getLevel();
            this.neighborChanged(level.getBlockState(pos), level, pos, state.getBlock(), pos, false);
        }
        return onWrenched;
    }

    public boolean hasShaftTowards(LevelReader reader, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public float getParticleTargetRadius() {
        return 0.35f;
    }

    public float getParticleInitialRadius() {
        return 0.25f;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public Class<WormGearBE> getBlockEntityClass() {
        return WormGearBE.class;
    }

    public BlockEntityType<? extends WormGearBE> getBlockEntityType() {
        return (BlockEntityType)GearsBETypes.WORM_GEAR.get();
    }

    public static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(arg_0 -> GearsBlocks.WORM_GEAR.has(arg_0), s -> ((Direction)s.getValue((Property)DirectionalKineticBlock.FACING)).getAxis(), (Property)DirectionalKineticBlock.FACING);
        }

        @NotNull
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> GearsBlocks.WORM_GEAR.isIn(arg_0);
        }
    }

    public static class PlacementHelperLargeCog
    implements IPlacementHelper {
        @NotNull
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @NotNull
        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> GearsBlocks.WORM_GEAR.has(arg_0);
        }

        @NotNull
        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.getDirection();
            Direction.Axis faceAxis = face.getAxis();
            for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)faceAxis)) {
                BlockPos newPos;
                Direction.Axis axis = dir.getAxis();
                if (axis == ((Direction)state.getValue((Property)DirectionalKineticBlock.FACING)).getAxis() || axis == faceAxis || !CogWheelBlock.isValidCogwheelPosition((boolean)false, (LevelReader)level, (BlockPos)(newPos = pos.relative(dir)), (Direction.Axis)axis) || !level.getBlockState(newPos).canBeReplaced()) continue;
                return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)BlockStateProperties.AXIS, (Comparable)faceAxis));
            }
            return PlacementOffset.fail();
        }
    }
}

