/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.tiny_cog;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.tiny_cog.TinyCogBE;
import dev.lopyluna.gnkinetics.register.GearsBETypes;
import dev.lopyluna.gnkinetics.register.GearsShapes;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class TinyCogBlock
extends RotatedPillarKineticBlock
implements IBE<TinyCogBE>,
ProperWaterloggedBlock {
    private static final int placementHelperID = PlacementHelpers.register((IPlacementHelper)new TinyCogLargeCogHelper());
    public final boolean hasShaft;

    public TinyCogBlock(boolean hasShaft, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.hasShaft = hasShaft;
    }

    public static boolean isTinyCog(BlockState state) {
        return TinyCogBlock.isTinyCog(state.getBlock());
    }

    public static boolean isTinyCog(Block block) {
        return block instanceof TinyCogBlock;
    }

    public static boolean isTinyCog(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        return TinyCogBlock.isTinyCog(blockItem.getBlock());
    }

    public static boolean isTinyCog(Item item) {
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        return TinyCogBlock.isTinyCog(blockItem.getBlock());
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperID);
        if (helper.matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BlockStateProperties.WATERLOGGED}));
    }

    public static TinyCogBlock shaftless(BlockBehaviour.Properties properties) {
        return new TinyCogBlock(false, properties);
    }

    public static TinyCogBlock shaft(BlockBehaviour.Properties properties) {
        return new TinyCogBlock(true, properties);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = GearsShapes.cuboid(3.5, 5.0, 3.5, 12.5, 11.0, 12.5);
        return this.hasShaft ? GearsShapes.shape(shape).add(AllShapes.SIX_VOXEL_POLE.get(Direction.Axis.Y)).forAxis().get((Direction.Axis)state.getValue((Property)AXIS)) : GearsShapes.shape(shape).forAxis().get((Direction.Axis)state.getValue((Property)AXIS));
    }

    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        Block block;
        BlockPos placedOnPos;
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            return context.getClickedFace().getAxis();
        }
        Level level = context.getLevel();
        BlockState placedAgainst = level.getBlockState(placedOnPos = context.getClickedPos().relative(context.getClickedFace().getOpposite()));
        if (ICogWheel.isSmallCog((BlockState)placedAgainst) && (block = placedAgainst.getBlock()) instanceof IRotate) {
            IRotate rot = (IRotate)block;
            return rot.getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = TinyCogBlock.getPreferredAxis((BlockPlaceContext)context);
        return preferredAxis != null ? preferredAxis : context.getClickedFace().getAxis();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.withWater((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)this.getAxisForPlacement(context)), context);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.hasShaft && face.getAxis() == this.getRotationAxis(state);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    public Class<TinyCogBE> getBlockEntityClass() {
        return TinyCogBE.class;
    }

    public BlockEntityType<? extends TinyCogBE> getBlockEntityType() {
        return (BlockEntityType)GearsBETypes.TINY_COG.get();
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @MethodsReturnNonnullByDefault
    private static class TinyCogLargeCogHelper
    implements IPlacementHelper {
        private TinyCogLargeCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public Predicate<BlockState> getStatePredicate() {
            return TinyCogBlock::isTinyCog;
        }

        public PlacementOffset getOffset(@NotNull Player player, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull BlockHitResult ray) {
            Block block = state.getBlock();
            if (block instanceof IRotate) {
                IRotate rot = (IRotate)block;
                Direction.Axis axis = rot.getRotationAxis(state);
                for (Direction dir : IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)axis)) {
                    BlockPos newPos = pos.relative(dir);
                    if (!CogWheelBlock.isValidCogwheelPosition((boolean)false, (LevelReader)level, (BlockPos)newPos, (Direction.Axis)axis) || !level.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
                }
            }
            return PlacementOffset.fail();
        }
    }
}

