/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.contraptions.bearing.SailBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelStructuralBlock;
import com.simibubi.create.foundation.block.render.MultiPosDestructionHandler;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear.RingGearBlock;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import dev.lopyluna.gnkinetics.register.GearsShapes;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class RingGearStructure
extends DirectionalBlock
implements IWrenchable,
IProxyHoveringInformation {
    private static final int ringGearHelperId = PlacementHelpers.register((IPlacementHelper)new RingGearHelper());
    private static final int largeCogHelperId = PlacementHelpers.register((IPlacementHelper)new LargeCogHelper());
    private static final int smallCogHelperId = PlacementHelpers.register((IPlacementHelper)new SmallCogHelper());
    public static final MapCodec<RingGearStructure> CODEC = RingGearStructure.simpleCodec(RingGearStructure::new);

    public RingGearStructure(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper ringGear = PlacementHelpers.get((int)ringGearHelperId);
        IPlacementHelper largeCog = PlacementHelpers.get((int)largeCogHelperId);
        IPlacementHelper smallCog = PlacementHelpers.get((int)smallCogHelperId);
        IPlacementHelper placer = null;
        if (ringGear.matchesItem(stack)) {
            placer = ringGear;
        }
        if (largeCog.matchesItem(stack)) {
            placer = largeCog;
        }
        if (smallCog.matchesItem(stack)) {
            placer = smallCog;
        }
        if (placer != null) {
            return placer.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING}));
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext eContext;
        BlockPos masterPos = RingGearStructure.getMaster(level, pos, state);
        BlockState masterState = level.getBlockState(masterPos);
        if (masterState.getBlock() instanceof RingGearBlock) {
            return GearsShapes.shape(GearsShapes.cuboid(0.0, 4.0, 0.0, 16.0, 12.0, 16.0)).forAxis().get((Direction.Axis)masterState.getValue((Property)RingGearBlock.AXIS));
        }
        return context instanceof EntityCollisionContext && (eContext = (EntityCollisionContext)context).getEntity() != null ? Shapes.empty() : Shapes.block();
    }

    @NotNull
    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected boolean isOcclusionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
    }

    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public PushReaction getPistonPushReaction(@NotNull BlockState pState) {
        return PushReaction.BLOCK;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return GearsBlocks.RING_GEAR.asStack();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.getClickedPos();
        Level level = context.getLevel();
        if (this.stillValid((BlockGetter)level, clickedPos, state, false)) {
            BlockPos masterPos = RingGearStructure.getMaster((BlockGetter)level, clickedPos, state);
            context = new UseOnContext(level, context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), masterPos, context.isInside()));
            state = level.getBlockState(masterPos);
        }
        return super.onSneakWrenched(state, context);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            pLevel.destroyBlock(RingGearStructure.getMaster((BlockGetter)pLevel, pPos, pState), true);
        }
    }

    @NotNull
    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            BlockPos masterPos = RingGearStructure.getMaster((BlockGetter)pLevel, pPos, pState);
            pLevel.destroyBlockProgress(masterPos.hashCode(), masterPos, -1);
            if (!pLevel.isClientSide() && pPlayer.isCreative()) {
                pLevel.destroyBlock(masterPos, false);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        Level level;
        if (this.stillValid((BlockGetter)pLevel, pCurrentPos, pState, false)) {
            BlockPos masterPos = RingGearStructure.getMaster((BlockGetter)pLevel, pCurrentPos, pState);
            if (!pLevel.getBlockTicks().hasScheduledTick(masterPos, (Object)((Block)GearsBlocks.RING_GEAR.get()))) {
                pLevel.scheduleTick(masterPos, (Block)GearsBlocks.RING_GEAR.get(), 1);
            }
            return pState;
        }
        if (!(pLevel instanceof Level) || (level = (Level)pLevel).isClientSide()) {
            return pState;
        }
        if (!level.getBlockTicks().hasScheduledTick(pCurrentPos, (Object)this)) {
            level.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public static BlockPos getMaster(BlockGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos targetedPos = pos.relative(direction);
        BlockState targetedState = level.getBlockState(targetedPos);
        if (targetedState.is((Block)GearsBlocks.RING_GEAR_STRUCT.get())) {
            return RingGearStructure.getMaster(level, targetedPos, targetedState);
        }
        return targetedPos;
    }

    public boolean stillValid(BlockGetter level, BlockPos pos, BlockState state, boolean directlyAdjacent) {
        if (!state.is((Block)this)) {
            return false;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos targetedPos = pos.relative(direction);
        BlockState targetedState = level.getBlockState(targetedPos);
        if (!directlyAdjacent && this.stillValid(level, targetedPos, targetedState, true)) {
            return true;
        }
        return targetedState.getBlock() instanceof RingGearBlock && targetedState.getValue((Property)RingGearBlock.AXIS) != direction.getAxis();
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.stillValid((BlockGetter)pLevel, pPos, pState, false)) {
            pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
        }
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        return this.stillValid((BlockGetter)level, pos, state, false) ? RingGearStructure.getMaster((BlockGetter)level, pos, state) : pos;
    }

    @MethodsReturnNonnullByDefault
    private static class RingGearHelper
    implements IPlacementHelper {
        private RingGearHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.is(GearsBlocks.RING_GEAR.asItem());
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.getBlock() instanceof RingGearStructure;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction dir = (Direction)state.getValue((Property)SailBlock.FACING);
            Direction placeDir = dir.getOpposite();
            Direction.Axis faceAxis = ray.getDirection().getAxis();
            BlockState gear = level.getBlockState(pos.relative(dir));
            BlockPos placePos = pos.relative(placeDir, 2);
            BlockState placeState = level.getBlockState(placePos);
            if (gear.is(GearsBlocks.RING_GEAR) && faceAxis != dir.getAxis() && (placeState.isEmpty() || placeState.canBeReplaced()) && placeState.canSurvive((LevelReader)level, placePos) && RingGearBlock.canPlace(faceAxis, placePos, level)) {
                Direction.Axis axis = (Direction.Axis)gear.getValue((Property)RingGearBlock.AXIS);
                return PlacementOffset.success((Vec3i)placePos, s -> {
                    BlockState newState = s;
                    if (s.hasProperty((Property)BlockStateProperties.AXIS)) {
                        newState = (BlockState)newState.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
                    }
                    if (s.hasProperty((Property)BlockStateProperties.FACING)) {
                        newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                    }
                    return newState;
                });
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    private static class LargeCogHelper
    implements IPlacementHelper {
        private LargeCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.getBlock() instanceof RingGearStructure;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction dir = (Direction)state.getValue((Property)SailBlock.FACING);
            Direction.Axis placeAxis = dir.getAxis();
            Direction face = ray.getDirection();
            BlockState gear = level.getBlockState(pos.relative(dir));
            BlockPos placePos = pos.relative(face);
            BlockState placeState = level.getBlockState(placePos);
            if (gear.is(GearsBlocks.RING_GEAR) && face.getAxis() != placeAxis && (placeState.isEmpty() || placeState.canBeReplaced()) && placeState.canSurvive((LevelReader)level, placePos)) {
                return PlacementOffset.success((Vec3i)placePos, s -> {
                    BlockState newState = s;
                    if (s.hasProperty((Property)BlockStateProperties.AXIS)) {
                        newState = (BlockState)newState.setValue((Property)BlockStateProperties.AXIS, (Comparable)placeAxis);
                    }
                    if (s.hasProperty((Property)BlockStateProperties.FACING)) {
                        newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)placeAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                    }
                    return newState;
                });
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    private static class SmallCogHelper
    implements IPlacementHelper {
        private SmallCogHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.getBlock() instanceof RingGearStructure;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction dir = (Direction)state.getValue((Property)SailBlock.FACING);
            Direction placeDir = dir.getOpposite();
            BlockState gear = level.getBlockState(pos.relative(dir));
            BlockPos placePos = pos.relative(placeDir);
            BlockState placeState = level.getBlockState(placePos);
            if (gear.is(GearsBlocks.RING_GEAR) && (placeState.isEmpty() || placeState.canBeReplaced()) && placeState.canSurvive((LevelReader)level, placePos)) {
                Direction.Axis axis = (Direction.Axis)gear.getValue((Property)RingGearBlock.AXIS);
                return PlacementOffset.success((Vec3i)placePos, s -> {
                    BlockState newState = s;
                    if (s.hasProperty((Property)BlockStateProperties.AXIS)) {
                        newState = (BlockState)newState.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
                    }
                    if (s.hasProperty((Property)BlockStateProperties.FACING)) {
                        newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                    }
                    return newState;
                });
            }
            return PlacementOffset.fail();
        }
    }

    public static class RenderProperties
    implements IClientBlockExtensions,
    MultiPosDestructionHandler {
        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            return true;
        }

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)target;
                BlockPos targetPos = bhr.getBlockPos();
                RingGearStructure structure = (RingGearStructure)((Object)GearsBlocks.RING_GEAR_STRUCT.get());
                if (structure.stillValid((BlockGetter)level, targetPos, state, false)) {
                    manager.crack(RingGearStructure.getMaster((BlockGetter)level, targetPos, state), bhr.getDirection());
                }
                return true;
            }
            return super.addHitEffects(state, level, target, manager);
        }

        @Nullable
        public Set<BlockPos> getExtraPositions(ClientLevel level, BlockPos pos, BlockState blockState, int progress) {
            RingGearStructure structure = (RingGearStructure)((Object)GearsBlocks.RING_GEAR_STRUCT.get());
            if (!structure.stillValid((BlockGetter)level, pos, blockState, false)) {
                return null;
            }
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(WaterWheelStructuralBlock.getMaster((BlockGetter)level, (BlockPos)pos, (BlockState)blockState));
            return set;
        }
    }
}

