/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear;

import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs.CustomCogWheelBlock;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear.RingGearBE;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear.RingGearStructure;
import dev.lopyluna.gnkinetics.register.GearsBETypes;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class RingGearBlock
extends RotatedPillarKineticBlock
implements IBE<RingGearBE>,
ICogWheel {
    public static final BooleanProperty HAS_SHAFT = CustomCogWheelBlock.HAS_SHAFT;
    public static final BooleanProperty EXTENSION = BooleanProperty.create((String)"extension");

    public RingGearBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HAS_SHAFT, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTENSION, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{HAS_SHAFT}).add(new Property[]{EXTENSION}));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext eContext;
        return context instanceof EntityCollisionContext && (eContext = (EntityCollisionContext)context).getEntity() != null ? Block.box((double)8.0, (double)8.0, (double)8.0, (double)8.001, (double)8.001, (double)8.001) : Shapes.block();
    }

    @NotNull
    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected boolean isOcclusionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    @NotNull
    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        return (Direction.Axis)Objects.requireNonNull(super.getStateForPlacement(context)).getValue((Property)AXIS);
    }

    public static boolean canPlace(Direction.Axis axis, BlockPos pos, Level level) {
        for (Direction face : Iterate.directions) {
            for (Direction dir : Iterate.directions) {
                if (face.getAxis() == axis || dir.getAxis() == axis || dir == face) continue;
                BlockState state1 = level.getBlockState(pos.relative(face).relative(dir));
                if (!state1.isEmpty() && !state1.canBeReplaced()) {
                    return false;
                }
                BlockState state2 = level.getBlockState(pos.relative(face));
                if (state2.isEmpty() || state2.canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement = super.getStateForPlacement(context);
        assert (stateForPlacement != null);
        BlockPos pos = context.getClickedPos();
        Direction.Axis axis = (Direction.Axis)stateForPlacement.getValue((Property)AXIS);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState occupiedState;
                    BlockPos offset;
                    if (axis.choose(x, y, z) != 0 || (offset = new BlockPos(x, y, z)).equals((Object)BlockPos.ZERO) || (occupiedState = context.getLevel().getBlockState(pos.offset((Vec3i)offset))).canBeReplaced()) continue;
                    return null;
                }
            }
        }
        if (context.getLevel().getBlockState(pos.relative(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE))).is((Block)this)) {
            stateForPlacement = (BlockState)stateForPlacement.setValue((Property)EXTENSION, (Comparable)Boolean.valueOf(true));
        }
        return stateForPlacement;
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection != Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)pState.getValue((Property)AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)) {
            return pState;
        }
        return (BlockState)pState.setValue((Property)EXTENSION, (Comparable)Boolean.valueOf(pNeighborState.is((Block)this)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Direction.Axis axis = (Direction.Axis)pState.getValue((Property)AXIS);
        for (Direction side : Iterate.directions) {
            if (side.getAxis() == axis) continue;
            boolean[] blArray = Iterate.falseAndTrue;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                BlockState requiredStructure;
                Direction targetSide;
                boolean secondary;
                BlockPos structurePos = (secondary ? pPos.relative(side) : pPos).relative(targetSide = (secondary = blArray[i]) ? side.getClockWise(axis) : side);
                BlockState occupiedState = pLevel.getBlockState(structurePos);
                if (occupiedState == (requiredStructure = (BlockState)GearsBlocks.RING_GEAR_STRUCT.getDefaultState().setValue((Property)RingGearStructure.FACING, (Comparable)targetSide.getOpposite()))) continue;
                if (!occupiedState.canBeReplaced()) {
                    pLevel.destroyBlock(pPos, false);
                    return;
                }
                pLevel.setBlockAndUpdate(structurePos, requiredStructure);
            }
        }
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return (Boolean)state.getValue((Property)HAS_SHAFT) != false && face.getAxis() == this.getRotationAxis(state);
    }

    public Class<RingGearBE> getBlockEntityClass() {
        return RingGearBE.class;
    }

    public BlockEntityType<? extends RingGearBE> getBlockEntityType() {
        return (BlockEntityType)GearsBETypes.RING_GEAR.get();
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public float getParticleTargetRadius() {
        return 2.0f;
    }

    public float getParticleInitialRadius() {
        return 1.5f;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public boolean isLargeCog() {
        return true;
    }

    public boolean isSmallCog() {
        return false;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

