/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.ring_gear.RingGearBlock;
import dev.lopyluna.gnkinetics.register.GearsBlocks;
import dev.lopyluna.gnkinetics.register.GearsRotationPropagation;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RingGearBE
extends KineticBlockEntity {
    public RingGearBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (GearsRotationPropagation.isSamePlaneAndAxis(stateFrom, stateTo, diff)) {
            Direction.Axis axis = GearsRotationPropagation.getAxis(stateFrom);
            for (Direction dir : Iterate.directions) {
                if (dir.getAxis() == axis) continue;
                assert (target.getLevel() != null);
                int dif = diff.get(dir.getAxis());
                if (Mth.abs((int)dif) == 3 && stateTo.is(GearsBlocks.RING_GEAR) && stateFrom.is(GearsBlocks.RING_GEAR)) {
                    return -1.0f;
                }
                if (Mth.abs((int)dif) == 2 && ICogWheel.isSmallCog((BlockState)stateFrom) && stateTo.is(GearsBlocks.RING_GEAR)) {
                    return -0.25f;
                }
                if (Mth.abs((int)dif) != 2 || !ICogWheel.isSmallCog((BlockState)stateTo) || !stateFrom.is(GearsBlocks.RING_GEAR)) continue;
                return -4.0f;
            }
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return state.getBlock() instanceof ICogWheel || block instanceof ICogWheel;
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        for (Direction dir : Iterate.directions) {
            if (dir.getAxis() == state.getValue((Property)RingGearBlock.AXIS)) continue;
            neighbours.add(this.worldPosition.relative(dir, 2));
            neighbours.add(this.worldPosition.relative(dir, 3));
        }
        for (BlockPos offset : BlockPos.betweenClosed((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1)) {
            if (offset.distSqr((Vec3i)BlockPos.ZERO) != 2.0) continue;
            neighbours.add(this.worldPosition.offset((Vec3i)offset));
        }
        return super.addPropagationLocations(block, state, neighbours);
    }
}

