/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.magnet_gears;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.custom_cogs.CustomCogWheelRenderer;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.magnet_gears.MagnetGearBlock;
import dev.lopyluna.gnkinetics.mixins.RotationPropagatorAccessor;
import dev.lopyluna.gnkinetics.register.client.GearsPartialModels;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MagnetGearRenderer
extends KineticBlockEntityRenderer<SimpleKineticBlockEntity> {
    private final boolean large;

    public static MagnetGearRenderer small(BlockEntityRendererProvider.Context context) {
        return new MagnetGearRenderer(context, false);
    }

    public static MagnetGearRenderer large(BlockEntityRendererProvider.Context context) {
        return new MagnetGearRenderer(context, true);
    }

    public MagnetGearRenderer(BlockEntityRendererProvider.Context context, boolean large) {
        super(context);
        this.large = large;
    }

    protected void renderSafe(SimpleKineticBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        Level level = be.getLevel();
        BlockState blockState = be.getBlockState();
        Block block = blockState.getBlock();
        if (!(block instanceof IRotate)) {
            return;
        }
        IRotate rot = (IRotate)block;
        Direction.Axis axis = MagnetGearRenderer.getRotationAxisOf((KineticBlockEntity)be);
        BlockPos pos = be.getBlockPos();
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)MagnetGearRenderer.getRotationAxisOf((KineticBlockEntity)be))) {
            float modifier;
            if (!rot.hasShaftTowards((LevelReader)level, pos, blockState, d)) continue;
            float angle = CustomCogWheelRenderer.getAngleForLargeCogShaft((KineticBlockEntity)be, axis, 0.0f, modifier, (modifier = RotationPropagatorAccessor.getAxisModifier((KineticBlockEntity)be, d)) >= 0.0f);
            SuperByteBuffer shaft = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)blockState, (Direction)d);
            MagnetGearRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
            shaft.renderInto(ms, buffer.getBuffer(RenderType.solid()));
        }
    }

    protected SuperByteBuffer getRotatedModel(SimpleKineticBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacingVertical((PartialModel)(this.large ? GearsPartialModels.SHAFTLESS_LARGE_MAGNET_GEAR : GearsPartialModels.SHAFTLESS_MAGNET_GEAR), (BlockState)state, (Direction)Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue((Property)MagnetGearBlock.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
    }
}

