/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.magnet_gears;

import com.simibubi.create.AllShapes;
import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.magnet_gears.MagnetGearBE;
import dev.lopyluna.gnkinetics.register.GearsBETypes;
import dev.lopyluna.gnkinetics.register.GearsShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class MagnetGearBlock
extends RotatedPillarKineticBlock
implements ICogWheel,
IBE<MagnetGearBE>,
TransformableBlock {
    public static final BooleanProperty TOP_SHAFT = BooleanProperty.create((String)"top_shaft");
    public static final BooleanProperty BOTTOM_SHAFT = BooleanProperty.create((String)"bottom_shaft");
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    boolean isLarge;

    protected MagnetGearBlock(boolean large, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP_SHAFT, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM_SHAFT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y));
        this.isLarge = large;
    }

    public static MagnetGearBlock small(BlockBehaviour.Properties properties) {
        return new MagnetGearBlock(false, properties);
    }

    public static MagnetGearBlock large(BlockBehaviour.Properties properties) {
        return new MagnetGearBlock(true, properties);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        AllShapes.Builder shape = GearsShapes.shape(this.isLarge ? GearsShapes.cuboid(0.0, 4.0, 0.0, 16.0, 12.0, 16.0) : GearsShapes.cuboid(2.0, 4.0, 2.0, 14.0, 12.0, 14.0));
        if (((Boolean)state.getValue((Property)TOP_SHAFT)).booleanValue()) {
            shape = shape.add(GearsShapes.shape(5.0, 0.0, 5.0, 11.0, 6.0, 11.0).forDirectional().get(Direction.DOWN));
        }
        if (((Boolean)state.getValue((Property)BOTTOM_SHAFT)).booleanValue()) {
            shape = shape.add(GearsShapes.shape(5.0, 0.0, 5.0, 11.0, 6.0, 11.0).forDirectional().get(Direction.UP));
        }
        return shape.forAxis().get((Direction.Axis)state.getValue((Property)AXIS));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{POWERED, TOP_SHAFT, BOTTOM_SHAFT}));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)level, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == state.getValue((Property)AXIS) && (Boolean)state.getValue((Property)(face.getAxisDirection() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT)) != false;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 18);
            this.detachKinetics(level, pos, true);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placedOn = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()));
        BlockState stateForPlacement = super.getStateForPlacement(context);
        if (ICogWheel.isSmallCog((BlockState)placedOn) && stateForPlacement != null) {
            stateForPlacement = (BlockState)stateForPlacement.setValue((Property)AXIS, (Comparable)((IRotate)placedOn.getBlock()).getRotationAxis(placedOn));
        }
        return stateForPlacement != null ? (BlockState)stateForPlacement.setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos()))) : null;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction.AxisDirection axisDir = this.hitOnShaft(null, state, context);
        if (context.getClickedFace().getAxis() != state.getValue((Property)AXIS) && axisDir == null) {
            return super.onWrenched(state, context);
        }
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.cycle((Property)(this.hitOnShaft(axisDir == null ? context.getClickedFace().getAxisDirection() : axisDir, state, context) == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT))));
        IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    protected Direction.AxisDirection hitOnShaft(@Nullable Direction.AxisDirection axisDirection, BlockState state, UseOnContext ray) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        Direction negDir = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
        if (((Boolean)state.getValue((Property)TOP_SHAFT)).booleanValue() && GearsShapes.shape(5.0, 0.0, 5.0, 11.0, 6.0, 11.0).forDirectional().get(negDir).bounds().inflate(0.001).contains(ray.getClickLocation().subtract(ray.getClickLocation().align(Iterate.axisSet)))) {
            return Direction.AxisDirection.POSITIVE;
        }
        Direction posDir = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        if (((Boolean)state.getValue((Property)BOTTOM_SHAFT)).booleanValue() && GearsShapes.shape(5.0, 0.0, 5.0, 11.0, 6.0, 11.0).forDirectional().get(posDir).bounds().inflate(0.001).contains(ray.getClickLocation().subtract(ray.getClickLocation().align(Iterate.axisSet)))) {
            return Direction.AxisDirection.NEGATIVE;
        }
        return axisDirection;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        originalState = this.swapShaftsForRotation(originalState, Rotation.CLOCKWISE_90, targetedFace.getAxis());
        return (BlockState)originalState.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)((Direction.Axis)originalState.getValue((Property)RotatedPillarKineticBlock.AXIS))).getClockWise(targetedFace.getAxis()).getAxis());
    }

    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public float getParticleTargetRadius() {
        return this.isLargeCog() ? 1.125f : 0.65f;
    }

    public float getParticleInitialRadius() {
        return this.isLargeCog() ? 1.0f : 0.75f;
    }

    public boolean isDedicatedCogWheel() {
        return true;
    }

    public Class<MagnetGearBE> getBlockEntityClass() {
        return MagnetGearBE.class;
    }

    public BlockEntityType<? extends MagnetGearBE> getBlockEntityType() {
        return this.isLarge ? (BlockEntityType)GearsBETypes.LARGE_MAGNET_GEAR.get() : (BlockEntityType)GearsBETypes.MAGNET_GEAR.get();
    }

    public void detachKinetics(Level level, BlockPos pos, boolean reAttachNextTick) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity be = (KineticBlockEntity)blockEntity;
        RotationPropagator.handleRemoved((Level)level, (BlockPos)pos, (KineticBlockEntity)be);
        if (reAttachNextTick) {
            level.scheduleTick(pos, (Block)this, 1, TickPriority.EXTREMELY_HIGH);
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity kte = (KineticBlockEntity)blockEntity;
        RotationPropagator.handleAdded((Level)worldIn, (BlockPos)pos, (KineticBlockEntity)kte);
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (newState.getBlock() instanceof MagnetGearBlock && oldState.getBlock() instanceof MagnetGearBlock) {
            if (newState.getValue((Property)TOP_SHAFT) != oldState.getValue((Property)TOP_SHAFT)) {
                return false;
            }
            if (newState.getValue((Property)BOTTOM_SHAFT) != oldState.getValue((Property)BOTTOM_SHAFT)) {
                return false;
            }
        }
        return super.areStatesKineticallyEquivalent(oldState, newState);
    }

    public BlockState swapShafts(BlockState state) {
        boolean bottom = (Boolean)state.getValue((Property)BOTTOM_SHAFT);
        boolean top = (Boolean)state.getValue((Property)TOP_SHAFT);
        state = (BlockState)state.setValue((Property)BOTTOM_SHAFT, (Comparable)Boolean.valueOf(top));
        state = (BlockState)state.setValue((Property)TOP_SHAFT, (Comparable)Boolean.valueOf(bottom));
        return state;
    }

    public BlockState swapShaftsForRotation(BlockState state, Rotation rotation, Direction.Axis rotationAxis) {
        if (rotation == Rotation.NONE) {
            return state;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        if (axis == rotationAxis) {
            return state;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return this.swapShafts(state);
        }
        boolean clockwise = rotation == Rotation.CLOCKWISE_90;
        switch (rotationAxis) {
            case X: {
                if ((axis != Direction.Axis.Z || clockwise) && (axis != Direction.Axis.Y || !clockwise)) break;
                return this.swapShafts(state);
            }
            case Y: {
                if ((axis != Direction.Axis.X || clockwise) && (axis != Direction.Axis.Z || !clockwise)) break;
                return this.swapShafts(state);
            }
            case Z: {
                if ((axis != Direction.Axis.Y || clockwise) && (axis != Direction.Axis.X || !clockwise)) break;
                return this.swapShafts(state);
            }
        }
        return state;
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        if (axis == Direction.Axis.X && mirror == Mirror.FRONT_BACK || axis == Direction.Axis.Z && mirror == Mirror.LEFT_RIGHT) {
            return this.swapShafts(state);
        }
        return state;
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        state = this.swapShaftsForRotation(state, rotation, Direction.Axis.Y);
        return super.rotate(state, rotation);
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.mirror(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.rotate(state, transform.rotation);
        }
        state = this.swapShaftsForRotation(state, transform.rotation, transform.rotationAxis);
        state = (BlockState)state.setValue((Property)AXIS, (Comparable)transform.rotateAxis((Direction.Axis)state.getValue((Property)AXIS)));
        return state;
    }
}

