/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.gnkinetics.content.blocks.kinetics.magnet_gears;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import dev.lopyluna.gnkinetics.content.blocks.kinetics.magnet_gears.MagnetGearBlock;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MagnetGearBE
extends SimpleKineticBlockEntity {
    public MagnetGearBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLarge() {
        Block block = this.getBlockState().getBlock();
        if (!(block instanceof MagnetGearBlock)) return false;
        MagnetGearBlock block2 = (MagnetGearBlock)block;
        if (!block2.isLarge) return false;
        return true;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        assert (this.level != null);
        if (target instanceof MagnetGearBE) {
            MagnetGearBE be = (MagnetGearBE)target;
            Block block = stateTo.getBlock();
            if (block instanceof MagnetGearBlock) {
                MagnetGearBlock blockTo = (MagnetGearBlock)block;
                block = stateFrom.getBlock();
                if (block instanceof MagnetGearBlock) {
                    MagnetGearBlock blockFrom = (MagnetGearBlock)block;
                    Direction.Axis fromAxis = (Direction.Axis)stateFrom.getValue((Property)MagnetGearBlock.AXIS);
                    Direction.Axis toAxis = (Direction.Axis)stateTo.getValue((Property)MagnetGearBlock.AXIS);
                    Boolean fromPowered = (Boolean)stateFrom.getValue((Property)MagnetGearBlock.POWERED);
                    Boolean toPowered = (Boolean)stateTo.getValue((Property)MagnetGearBlock.POWERED);
                    if (!fromPowered.booleanValue() && !toPowered.booleanValue()) {
                        for (Direction dir : Iterate.directions) {
                            if (dir.getAxis() != fromAxis || fromAxis != toAxis || !dir.getNormal().equals((Object)diff) || blockTo.hasShaftTowards((LevelReader)this.level, be.getBlockPos(), stateTo, dir.getOpposite()) && blockFrom.hasShaftTowards((LevelReader)this.level, this.worldPosition, stateFrom, dir)) continue;
                            if (!this.isLarge() && be.isLarge()) {
                                return -0.5f;
                            }
                            if (this.isLarge() && !be.isLarge()) {
                                return -2.0f;
                            }
                            return -1.0f;
                        }
                    }
                }
            }
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return state.getBlock() instanceof ICogWheel || block instanceof ICogWheel;
    }
}

